/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

/**
 * Enum for including Region endpoints
 */
public enum RegionEndpoint {

    USEAST1("sns.us-east-1.amazonaws.com"), USWEST1("sns.us-west-1.amazonaws.com"), USWEST2("sns.us-west-2.amazonaws.com"), EUWEST1("sns.eu-west-1.amazonaws.com"), EUCENTRAL1(
            "sns.eu-central-1.amazonaws.com"), APSOUTHEAST1("sns.ap-southeast-1.amazonaws.com"), APSOUTHEAST2("sns.ap-southeast-2.amazonaws.com"), APNORTHEAST1(
            "sns.ap-northeast-1.amazonaws.com"), SAEAST1("sns.sa-east-1.amazonaws.com");

    private String value;

    RegionEndpoint(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    public String toString() {
        return this.value();
    }
}
