/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.Serializable;

/**
 * A wrapper type for the attributes of an Amazon SNS Subscribe operation.
 */
public class Subscribe implements Serializable {

    private static final long serialVersionUID = 3338398978353968543L;
    /**
     * The ARN of the topic you want to subscribe to.
     */
    @NotNull
    private String topicArn;

    /**
     * The protocol you want to use.
     */
    @NotNull
    private String protocol;

    /**
     * The endpoint that you want to receive notifications. Endpoints vary by protocol.
     */
    @Nullable
    private String endpoint;

    @Nullable
    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(@Nullable String endpoint) {
        this.endpoint = endpoint;
    }

    @NotNull
    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(@NotNull String protocol) {
        this.protocol = protocol;
    }

    @NotNull
    public String getTopicArn() {
        return topicArn;
    }

    public void setTopicArn(@NotNull String topicArn) {
        this.topicArn = topicArn;
    }
}
