/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

import org.jetbrains.annotations.Nullable;

import java.io.Serializable;

/**
 * A wrapper type for the attributes of an Amazon SNS subscription.
 */
public class Subscription implements Serializable {

    private static final long serialVersionUID = 9002051624859339297L;
    /**
     * The subscription's ARN.
     */
    @Nullable
    private String subscriptionArn;

    /**
     * The subscription's owner.
     */
    @Nullable
    private String owner;

    /**
     * The subscription's protocol.
     */
    @Nullable
    private String protocol;

    /**
     * The subscription's endpoint (format depends on the protocol).
     */
    @Nullable
    private String endpoint;

    /**
     * The ARN of the subscription's topic.
     */
    @Nullable
    private String topicArn;

    public Subscription(String endpoint, String owner, String protocol, String subscriptionArn, String topicArn) {
        this.endpoint = endpoint;
        this.owner = owner;
        this.protocol = protocol;
        this.subscriptionArn = subscriptionArn;
        this.topicArn = topicArn;
    }

    public String getEndpoint() {
        return endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getOwner() {
        return owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getSubscriptionArn() {
        return subscriptionArn;
    }

    public void setSubscriptionArn(String subscriptionArn) {
        this.subscriptionArn = subscriptionArn;
    }

    public String getTopicArn() {
        return topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }
}
