/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.io.Serializable;

/**
 * A wrapper type for the attributes of SetSubscriptionAttributes operation.
 */
public class SubscriptionAttributes implements Serializable {

    private static final long serialVersionUID = 3811104630882776622L;
    /**
     * The ARN of the subscription to modify.
     */
    @NotNull
    private String subscriptionArn;

    /**
     * The name of the attribute you want to set. Only a subset of the subscriptions attributes are mutable. Valid values: DeliveryPolicy | RawMessageDelivery
     */
    @NotNull
    private String attributeName;

    /**
     * The new value for the attribute in JSON format
     */
    @Nullable
    private String attributeValue;

    @NotNull
    public String getAttributeName() {
        return attributeName;
    }

    public void setAttributeName(@NotNull String attributeName) {
        this.attributeName = attributeName;
    }

    @Nullable
    public String getAttributeValue() {
        return attributeValue;
    }

    public void setAttributeValue(@Nullable String attributeValue) {
        this.attributeValue = attributeValue;
    }

    @NotNull
    public String getSubscriptionArn() {
        return subscriptionArn;
    }

    public void setSubscriptionArn(@NotNull String subscriptionArn) {
        this.subscriptionArn = subscriptionArn;
    }
}
