/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.model;

import java.io.Serializable;

/**
 * Container for the parameters to the ListSubscriptionsByTopic operation.
 */
public class SubscriptionsByTopic implements Serializable {

    private static final long serialVersionUID = -2440163882478494251L;
    /**
     * The ARN of the topic for which you wish to find subscriptions.
     */
    private String topicArn;

    /**
     * Token returned by the previous ListSubscriptionsByTopic request.
     */
    private String nextToken;

    public String getNextToken() {
        return nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getTopicArn() {
        return topicArn;
    }

    public void setTopicArn(String topicArn) {
        this.topicArn = topicArn;
    }
}
