/**
 * (c) 2003-2015 MuleSoft, Inc. The software in this package is
 * published under the terms of the CPAL v1.0 license, a copy of which
 * has been included with this distribution in the LICENSE.md file.
 */
package org.mule.modules.sns.util;

import com.amazonaws.services.sns.model.ListSubscriptionsByTopicResult;
import com.amazonaws.services.sns.model.ListSubscriptionsResult;
import com.amazonaws.services.sns.model.ListTopicsResult;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import org.jetbrains.annotations.NotNull;
import org.mule.modules.sns.model.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SNSModelFactory {

    private SNSModelFactory() {

    }

    public static ListSubscriptions getListSubscriptions(@NotNull ListSubscriptionsResult result) {
        ListSubscriptions listSubscriptions = new ListSubscriptions();
        listSubscriptions.setNextToken(result.getNextToken());
        if (!result.getSubscriptions().isEmpty()) {
            List<Subscription> subscriptionList = new ArrayList<Subscription>(result.getSubscriptions().size());
            for (com.amazonaws.services.sns.model.Subscription subscription : result.getSubscriptions()) {
                Subscription local = new Subscription(subscription.getEndpoint(), subscription.getOwner(), subscription.getProtocol(), subscription.getSubscriptionArn(),
                        subscription.getTopicArn());
                subscriptionList.add(local);
            }
            listSubscriptions.setSubscriptions(subscriptionList);
        }
        return listSubscriptions;
    }

    public static ListSubscriptionsByTopic getListSubscriptionsByTopic(@NotNull ListSubscriptionsByTopicResult result) {
        ListSubscriptionsByTopic listSubscriptionsByTopic = new ListSubscriptionsByTopic();
        listSubscriptionsByTopic.setNextToken(result.getNextToken());
        if (!result.getSubscriptions().isEmpty()) {
            List<Subscription> subscriptionList = new ArrayList<Subscription>(result.getSubscriptions().size());
            for (com.amazonaws.services.sns.model.Subscription subscription : result.getSubscriptions()) {
                Subscription local = new Subscription(subscription.getEndpoint(), subscription.getOwner(), subscription.getProtocol(), subscription.getSubscriptionArn(),
                        subscription.getTopicArn());
                subscriptionList.add(local);
            }
            listSubscriptionsByTopic.setSubscriptions(subscriptionList);
        }
        return listSubscriptionsByTopic;
    }

    public static ListTopics getListTopics(ListTopicsResult result) {
        ListTopics listTopics = new ListTopics();
        listTopics.setNextToken(result.getNextToken());
        if (!result.getTopics().isEmpty()) {
            List<Topic> topicList = new ArrayList<Topic>(result.getTopics().size());
            for (com.amazonaws.services.sns.model.Topic topic : result.getTopics()) {
                Topic local = new Topic(topic.getTopicArn());
                topicList.add(local);
            }
            listTopics.setTopics(topicList);
        }
        return listTopics;
    }

    public static Map<String, MessageAttributeValue> getMessageAttributes(Map<String, MessageAttribute> messageAttributes) {
        Map<String, MessageAttributeValue> messageAttributeValueMap = new HashMap<String, MessageAttributeValue>();

        for (Map.Entry<String, MessageAttribute> attributeEntry : messageAttributes.entrySet()) {
            final MessageAttributeValue messageAttributeValue = new MessageAttributeValue();
            messageAttributeValue.setStringValue(attributeEntry.getValue().getStringValue());
            messageAttributeValue.setDataType(attributeEntry.getValue().getDataType());
            messageAttributeValueMap.put(attributeEntry.getKey(), messageAttributeValue);
        }

        return messageAttributeValueMap;
    }
}
