/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.InputStream;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.custommonkey.xmlunit.XMLAssert;
import org.junit.Test;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.xml.transformer.XsltTransformer;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;

public class ParallelXsltTransformerTestCase
extends AbstractMuleContextTestCase {
    private String srcData;
    private String resultData;
    private Collection<Object> actualResults = new ConcurrentLinkedQueue<Object>();
    int running = 0;

    protected void doSetUp() throws Exception {
        this.srcData = IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)"cdcatalog-utf-8.xml", ((Object)((Object)this)).getClass()), (String)"UTF-8");
        this.resultData = IOUtils.toString((InputStream)IOUtils.getResourceAsStream((String)"cdcatalog-utf-8.html", ((Object)((Object)this)).getClass()), (String)"UTF-8");
    }

    public Transformer getTransformer() throws Exception {
        XsltTransformer transformer = new XsltTransformer();
        transformer.setReturnDataType(DataTypeFactory.STRING);
        transformer.setXslFile("cdcatalog.xsl");
        transformer.setMuleContext(muleContext);
        transformer.initialise();
        return transformer;
    }

    public synchronized void signalStarted() {
        ++this.running;
    }

    public synchronized void signalDone() {
        if (--this.running == 0) {
            ((Object)((Object)this)).notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelTransformation() throws Exception {
        final Transformer transformer = this.getTransformer();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < this.getParallelThreadCount(); ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ParallelXsltTransformerTestCase.this.signalStarted();
                    for (int j = 0; j < ParallelXsltTransformerTestCase.this.getCallsPerThread(); ++j) {
                        try {
                            ParallelXsltTransformerTestCase.this.actualResults.add(transformer.transform((Object)ParallelXsltTransformerTestCase.this.srcData));
                            continue;
                        }
                        catch (TransformerException e) {
                            ParallelXsltTransformerTestCase.this.actualResults.add(e);
                        }
                    }
                    ParallelXsltTransformerTestCase.this.signalDone();
                }
            }).start();
        }
        ParallelXsltTransformerTestCase i = this;
        synchronized (i) {
            ((Object)((Object)this)).wait();
        }
        long endTime = System.currentTimeMillis();
        this.checkResult();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Parallel transformations in " + this.getParallelThreadCount() + " threads with " + this.getCallsPerThread() + " calls/thread took " + (endTime - startTime) + " ms."));
        }
    }

    protected void checkResult() throws Exception {
        String expectedResult = this.resultData;
        for (Object result : this.actualResults) {
            if (result instanceof Exception) {
                throw (Exception)result;
            }
            if (expectedResult instanceof String && result instanceof String) {
                XMLAssert.assertXMLEqual((String)expectedResult, (String)((String)result));
                continue;
            }
            XMLAssert.assertEquals((Object)expectedResult, (Object)result);
        }
    }

    private int getParallelThreadCount() {
        return 20;
    }

    private int getCallsPerThread() {
        return 100;
    }
}

