/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml.xslt;

import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.IOUtils;

public class Xslt3TestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "xsl/xslt3-config.xml";
    }

    protected void doSetUp() throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    @Test
    public void groupByCities() throws Exception {
        String cities = IOUtils.getResourceAsString((String)"cities.xml", ((Object)((Object)this)).getClass());
        String output = this.runFlow("groupCities", cities).getMessage().getPayloadAsString();
        String expected = IOUtils.getResourceAsString((String)"transformed-cities.xml", ((Object)((Object)this)).getClass());
        Assert.assertThat((Object)XMLUnit.compareXML((String)expected, (String)output).similar(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void booksAsCsv() throws Exception {
        String books = IOUtils.getResourceAsString((String)"books.xml", ((Object)((Object)this)).getClass());
        String output = this.runFlow("booksAsCsv", books).getMessage().getPayloadAsString();
        String expected = "Title,Author,Category,Stock-Value\n\"Pride and Prejudice\",\"Jane Austen\",\"MMP(Unclassified)\",\"N/A\"\n\"Wuthering Heights\",\"Charlotte Bronte\",\"P(Unclassified)\",\"N/A\"\n\"Tess of the d'Urbervilles\",\"Thomas Hardy\",\"P(Unclassified)\",\"N/A\"\n\"Jude the Obscure\",\"Thomas Hardy\",\"P(Unclassified)\",\"N/A\"\n\"The Big Over Easy\",\"Jasper Fforde\",\"H(Unclassified)\",\"N/A\"\n\"The Eyre Affair\",\"Jasper Fforde\",\"P(Unclassified)\",\"N/A\"";
        Assert.assertThat((Object)output.trim(), (Matcher)CoreMatchers.equalTo((Object)"Title,Author,Category,Stock-Value\n\"Pride and Prejudice\",\"Jane Austen\",\"MMP(Unclassified)\",\"N/A\"\n\"Wuthering Heights\",\"Charlotte Bronte\",\"P(Unclassified)\",\"N/A\"\n\"Tess of the d'Urbervilles\",\"Thomas Hardy\",\"P(Unclassified)\",\"N/A\"\n\"Jude the Obscure\",\"Thomas Hardy\",\"P(Unclassified)\",\"N/A\"\n\"The Big Over Easy\",\"Jasper Fforde\",\"H(Unclassified)\",\"N/A\"\n\"The Eyre Affair\",\"Jasper Fforde\",\"P(Unclassified)\",\"N/A\""));
    }

    @Test
    public void multipleInputs() throws Exception {
        String cities = IOUtils.getResourceAsString((String)"cities.xml", ((Object)((Object)this)).getClass());
        String response = this.runFlow("multipleInputs", cities).getMessage().getPayloadAsString();
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"<cities>"));
        Assert.assertThat((Object)response, (Matcher)CoreMatchers.containsString((String)"<BOOKS>"));
    }
}

