/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml.xslt;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.URIResolver;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.module.xml.transformer.XsltTransformer;
import org.mule.module.xml.util.LocalURIResolver;
import org.mule.module.xml.util.XMLTestUtils;
import org.mule.module.xml.util.XMLUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformers.xml.AbstractXmlTransformerTestCase;
import org.mule.util.IOUtils;

public class XsltTransformerTestCase
extends AbstractXmlTransformerTestCase {
    public static final String VALID_XSL_FILENAME = "cdcatalog.xsl";
    private String srcData;
    private String resultData;

    protected void doSetUp() throws Exception {
        this.srcData = IOUtils.getResourceAsString((String)"cdcatalog.xml", ((Object)((Object)this)).getClass());
        this.resultData = IOUtils.getResourceAsString((String)"cdcatalog.html", ((Object)((Object)this)).getClass());
    }

    public Transformer getTransformer() throws Exception {
        XsltTransformer transformer = new XsltTransformer();
        transformer.setReturnDataType(DataTypeFactory.STRING);
        transformer.setXslFile(VALID_XSL_FILENAME);
        transformer.setMaxActiveTransformers(42);
        transformer.setMuleContext(muleContext);
        transformer.initialise();
        return transformer;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        return null;
    }

    public void testRoundtripTransform() throws Exception {
    }

    public Object getTestData() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("ListTitle", "MyList");
        props.put("ListRating", new Integer(6));
        return new DefaultMuleMessage((Object)this.srcData, props, muleContext);
    }

    public Object getResultData() {
        return this.resultData;
    }

    @Test
    public void testAllXmlMessageTypes() throws Exception {
        List<?> list = XMLTestUtils.getXmlMessageVariants("cdcatalog.xml");
        Iterator<?> it = list.iterator();
        Object expectedResult = this.getResultData();
        Assert.assertNotNull((Object)expectedResult);
        while (it.hasNext()) {
            Object msg = it.next();
            Object result = this.getTransformer().transform(msg);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((String)("Test failed for message type: " + msg.getClass()), (boolean)this.compareResults(expectedResult, result));
        }
    }

    @Test
    public void testTransformXMLStreamReader() throws Exception {
        Object expectedResult = this.getResultData();
        Assert.assertNotNull((Object)expectedResult);
        XsltTransformer transformer = (XsltTransformer)this.getTransformer();
        InputStream is = IOUtils.getResourceAsStream((String)"cdcatalog.xml", XMLTestUtils.class);
        XMLStreamReader sr = XMLUtils.toXMLStreamReader((XMLInputFactory)transformer.getXMLInputFactory(), (Object)is);
        Object result = transformer.transform((Object)sr);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("expected: " + expectedResult + "\nresult: " + result), (boolean)this.compareResults(expectedResult, result));
    }

    @Test
    public void testCustomTransformerFactoryClass() throws InitialisationException {
        XsltTransformer t = new XsltTransformer();
        t.setXslTransformerFactory("com.nosuchclass.TransformerFactory");
        t.setXslFile(VALID_XSL_FILENAME);
        try {
            t.initialise();
            Assert.fail((String)"should have failed with ClassNotFoundException");
        }
        catch (InitialisationException iex) {
            Assert.assertEquals(ClassNotFoundException.class, iex.getCause().getClass());
        }
        t = new XsltTransformer();
        t.setXslFile(VALID_XSL_FILENAME);
        t.setXslTransformerFactory(null);
        t.initialise();
    }

    @Test
    public void testTransformWithStaticParam() throws TransformerException, InitialisationException {
        String xml = "<node1><subnode1>sub node 1 original value</subnode1><subnode2>sub node 2 original value</subnode2></node1>";
        String param = "sub node 2 cool new value";
        String expectedTransformedxml = "<node1><subnode1>sub node 1 original value</subnode1><subnode2>" + param + "</subnode2>" + "</node1>";
        String xsl = this.someXslText();
        XsltTransformer transformer = new XsltTransformer();
        transformer.setMuleContext(muleContext);
        transformer.setReturnDataType(DataTypeFactory.STRING);
        transformer.setXslt(xsl);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param1", param);
        transformer.setContextProperties(params);
        transformer.initialise();
        String transformerResult = (String)transformer.transform((Object)xml);
        transformerResult = transformerResult.substring(transformerResult.indexOf("?>") + 2);
        Assert.assertTrue((transformerResult.indexOf(expectedTransformedxml) > -1 ? 1 : 0) != 0);
    }

    private String someXslText() {
        return "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"2.0\" xmlns:wsdlsoap=\"http://schemas.xmlsoap.org/wsdl/soap/\" xmlns:wsdl=\"http://schemas.xmlsoap.org/wsdl/\"><xsl:param name=\"param1\"/><xsl:template match=\"@*|node()\"><xsl:copy><xsl:apply-templates select=\"@*|node()\"/></xsl:copy></xsl:template><xsl:template match=\"/node1/subnode2/text()\"><xsl:value-of select=\"$param1\"/></xsl:template></xsl:stylesheet>";
    }

    @Test
    public void testTransformWithDynamicParam() throws Exception {
        String xml = "<node1><subnode1>sub node 1 original value</subnode1><subnode2>sub node 2 original value</subnode2></node1>";
        String param = "sub node 2 cool new value";
        String expectedTransformedxml = "<node1><subnode1>sub node 1 original value</subnode1><subnode2>" + param + "</subnode2>" + "</node1>";
        String xsl = this.someXslText();
        XsltTransformer transformer = new XsltTransformer();
        transformer.setMuleContext(muleContext);
        transformer.setReturnDataType(DataTypeFactory.STRING);
        transformer.setMuleContext(muleContext);
        transformer.setXslt(xsl);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("param1", "#[header:myproperty]");
        transformer.setContextProperties(params);
        transformer.initialise();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)xml, muleContext);
        message.setOutboundProperty("myproperty", (Object)param);
        String transformerResult = (String)transformer.transform((Object)message);
        transformerResult = transformerResult.substring(transformerResult.indexOf("?>") + 2);
        Assert.assertTrue((transformerResult.indexOf(expectedTransformedxml) > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testInitialiseMustLoadXsltFile_dontLoadIfThereIsXslText() throws Exception {
        XsltTransformer xsltTransformer = new XsltTransformer();
        xsltTransformer.setXslt(this.someXslText());
        try {
            xsltTransformer.initialise();
            Assert.assertEquals((Object)this.someXslText(), (Object)xsltTransformer.getXslt());
        }
        catch (InitialisationException e) {
            Assert.fail((String)("Should not have thrown an exception: " + (Object)((Object)e)));
        }
    }

    @Test
    public void testInitialiseMustLoadXsltFile_ThrowExceptionIfNoXslTextNorFile() throws Exception {
        XsltTransformer xsltTransformer = new XsltTransformer();
        try {
            xsltTransformer.initialise();
            Assert.fail((String)"Should have thrown an exception because nor xslt-text nor xslt-file was set.");
        }
        catch (InitialisationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("xsl-file or xsl-text"));
        }
    }

    @Test
    public void testInitialiseMustLoadXsltFile_ThrowExceptionIfXslFileDoesNotExist() throws Exception {
        XsltTransformer xsltTransformer = new XsltTransformer();
        String someNonExistentFileName = "some nonexistent file";
        xsltTransformer.setXslFile(someNonExistentFileName);
        try {
            xsltTransformer.initialise();
            Assert.fail((String)("Should have thrown an exception because file '" + someNonExistentFileName + "' does not exist."));
        }
        catch (InitialisationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(someNonExistentFileName));
        }
    }

    @Test
    public void testInitialiseMustLoadXsltFile_LoadsFromXslFile() throws Exception {
        XsltTransformer xsltTransformer = new XsltTransformer();
        xsltTransformer.setXslFile(VALID_XSL_FILENAME);
        try {
            xsltTransformer.initialise();
            Assert.assertNotNull((Object)xsltTransformer.getXslt());
            String someTextThatIsInTheXslFile = "My CD Collection";
            Assert.assertTrue((String)("Should contain the text '" + someTextThatIsInTheXslFile + "', because it is in the '" + VALID_XSL_FILENAME + "' file that we are setting."), (boolean)xsltTransformer.getXslt().contains(someTextThatIsInTheXslFile));
        }
        catch (InitialisationException e) {
            Assert.fail((String)"Should NOT have thrown an exception because file 'cdcatalog.xsl' DOES exist.");
        }
    }

    @Test
    public void testInitialiseUriResolverIfNotSet() throws Exception {
        XsltTransformer xsltTransformer = new XsltTransformer();
        xsltTransformer.setXslFile(VALID_XSL_FILENAME);
        xsltTransformer.initialise();
        Assert.assertTrue((boolean)(xsltTransformer.getUriResolver() instanceof LocalURIResolver));
    }

    @Test
    public void testInitialiseMaintainsUriResolverIfSet() throws Exception {
        XsltTransformer xsltTransformer = new XsltTransformer();
        xsltTransformer.setXslFile(VALID_XSL_FILENAME);
        LocalURIResolver uriResolver = new LocalURIResolver();
        xsltTransformer.setUriResolver((URIResolver)uriResolver);
        xsltTransformer.initialise();
        Assert.assertEquals((Object)uriResolver, (Object)xsltTransformer.getUriResolver());
    }
}

