/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.el;

import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.el.context.AbstractELTestCase;
import org.w3c.dom.Document;

public class XMLExpressionLanguageEnrichmentW3CTestCase
extends AbstractELTestCase {
    public XMLExpressionLanguageEnrichmentW3CTestCase(AbstractELTestCase.Variant variant, String optimizer) {
        super(variant, optimizer);
    }

    @Test
    public void addElementText() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root/>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        this.evaluate("xpath('/root').setTextContent('myText')", (MuleMessage)message);
        this.evaluate("xpath('/root').setTextContent('myText')", (MuleMessage)message);
        Assert.assertTrue((boolean)message.getPayloadAsString().contains("<root>myText</root>"));
    }

    @Test
    public void addElementTextInt() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root/>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        this.evaluate("xpath('/root').setTextContent(1)", (MuleMessage)message);
        this.evaluate("xpath('/root').setTextContent(1)", (MuleMessage)message);
        Assert.assertTrue((boolean)message.getPayloadAsString().contains("<root>1</root>"));
    }

    @Test
    public void addElementTextNode() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root attr=\"1\"/>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        this.evaluate("xpath('/root').setTextContent(xpath('/root/@attr'))", (MuleMessage)message);
        this.evaluate("xpath('/root').setTextContent(xpath('/root/@attr'))", (MuleMessage)message);
        Assert.assertTrue((boolean)message.getPayloadAsString().contains("<root attr=\"1\">1</root>"));
    }

    @Test
    public void replaceElementText() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root>oldText</root>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        this.evaluate("xpath('/root').setTextContent('myText')", (MuleMessage)message);
        this.evaluate("xpath('/root').setTextContent('myText')", (MuleMessage)message);
        Assert.assertTrue((boolean)message.getPayloadAsString().contains("<root>myText</root>"));
    }

    @Test
    public void setAttribute() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root/>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        this.evaluate("xpath('/root').setAttribute('newAttr','attrValue')", (MuleMessage)message);
        this.evaluate("xpath('/root').setAttribute('newAttr','attrValue')", (MuleMessage)message);
        Assert.assertTrue((boolean)message.getPayloadAsString().contains("<root newAttr=\"attrValue\"/>"));
    }

    @Test
    public void setAttributeInt() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root/>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        this.evaluate("xpath('/root').setAttribute('newAttr',1)", (MuleMessage)message);
        this.evaluate("xpath('/root').setAttribute('newAttr',1)", (MuleMessage)message);
        Assert.assertTrue((boolean)message.getPayloadAsString().contains("<root newAttr=\"1\"/>"));
    }

    @Test
    public void setAttributeNode() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root other=\"1\"/>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        this.evaluate("xpath('/root').setAttribute('newAttr',xpath('/root/@other'))", (MuleMessage)message);
        this.evaluate("xpath('/root').setAttribute('newAttr',xpath('/root/@other'))", (MuleMessage)message);
        Assert.assertTrue((boolean)XMLUnit.compareXML((String)"<root other=\"1\" newAttr=\"1\"/>", (String)message.getPayloadAsString()).identical());
    }

    @Test
    public void updateAttributeValue() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root attr=\"oldValue\"/>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        this.evaluate("xpath('/root/@attr').setTextContent('newValue')", (MuleMessage)message);
        Assert.assertTrue((boolean)message.getPayloadAsString().contains("<root attr=\"newValue\"/>"));
    }

    @Test
    public void updateAttributeValueInt() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root attr=\"oldValue\"/>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        this.evaluate("xpath('/root/@attr').setTextContent('1')", (MuleMessage)message);
        Assert.assertTrue((boolean)message.getPayloadAsString().contains("<root attr=\"1\"/>"));
    }

    @Test
    public void updateAttributeValueNode() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root other=\"1\" attr=\"oldValue\"/>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        this.evaluate("xpath('/root/@attr').setTextContent(xpath('/root/@other'))", (MuleMessage)message);
        Assert.assertTrue((boolean)XMLUnit.compareXML((String)"<root other=\"1\" attr=\"1\"/>", (String)message.getPayloadAsString()).identical());
    }
}

