/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.el;

import java.io.ByteArrayInputStream;
import java.io.StringBufferInputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.tree.DefaultAttribute;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.el.context.AbstractELTestCase;

public class XPath1FunctionTestCase
extends AbstractELTestCase {
    public XPath1FunctionTestCase(AbstractELTestCase.Variant variant, String optimizer) {
        super(variant, optimizer);
    }

    @Test
    public void xpathFunctionString() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root foo=\"bar\"/>", muleContext);
        Assert.assertEquals(DefaultAttribute.class, this.evaluate("xpath('/root/@foo')", (MuleMessage)message).getClass());
    }

    @Test
    public void xpathFunctionStream() throws Exception {
        ByteArrayInputStream payload = new ByteArrayInputStream("<root foo=\"bar\"/>".getBytes());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)payload, muleContext);
        Assert.assertEquals(DefaultAttribute.class, this.evaluate("xpath('/root/@foo')", (MuleMessage)message).getClass());
        Assert.assertTrue((boolean)(message.getPayload() instanceof Document));
    }

    @Test
    public void xpathFunctionStringText() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"<root foo=\"bar\"/>", muleContext);
        message.setPayload(message.getPayload(Document.class));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("xpath('/root/@foo').text", (MuleMessage)message));
    }

    @Test
    public void xpathFunctionDom4j() throws Exception {
        Document document = DocumentHelper.parseText((String)"<root foo=\"bar\"/>");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)document, muleContext);
        Assert.assertEquals((Object)document.getRootElement().attribute("foo"), (Object)this.evaluate("xpath('/root/@foo')", (MuleMessage)message));
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("xpath('/root/@foo').text", (MuleMessage)message));
    }

    @Test
    public void xpathFunctionDom4jText() throws Exception {
        Document document = DocumentHelper.parseText((String)"<root foo=\"bar\"/>");
        DefaultMuleMessage message = new DefaultMuleMessage((Object)document, muleContext);
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("xpath('/root/@foo').text", (MuleMessage)message));
    }

    @Test
    public void xpathFunctionW3C() throws Exception {
        org.w3c.dom.Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new StringBufferInputStream("<root foo=\"bar\"/>"));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)document, muleContext);
        Assert.assertEquals((Object)document.getFirstChild().getAttributes().getNamedItem("foo"), (Object)this.evaluate("xpath('/root/@foo')", (MuleMessage)message));
    }

    @Test
    public void xpathFunctionW3CText() throws Exception {
        org.w3c.dom.Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new StringBufferInputStream("<root foo=\"bar\"/>"));
        DefaultMuleMessage message = new DefaultMuleMessage((Object)document, muleContext);
        Assert.assertEquals((Object)"bar", (Object)this.evaluate("xpath('/root/@foo').textContent", (MuleMessage)message));
    }
}

