/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.filters;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.module.xml.filters.SchemaValidationFilter;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class SchemaValidationTestCase
extends AbstractMuleTestCase {
    private static final String SIMPLE_SCHEMA = "schema1.xsd";
    private static final String INCLUDE_SCHEMA = "schema-with-include.xsd";
    private static final String VALID_XML_FILE = "/validation1.xml";
    private static final String INVALID_XML_FILE = "/validation2.xml";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;

    @Test
    public void testValidate() throws Exception {
        SchemaValidationFilter filter = new SchemaValidationFilter();
        filter.setSchemaLocations(SIMPLE_SCHEMA);
        filter.initialise();
        Assert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)((Object)((Object)this)).getClass().getResourceAsStream(VALID_XML_FILE), this.muleContext)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)((Object)((Object)this)).getClass().getResourceAsStream(INVALID_XML_FILE), this.muleContext)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testDefaultResourceResolverIsPresent() throws Exception {
        SchemaValidationFilter filter = new SchemaValidationFilter();
        filter.setSchemaLocations(SIMPLE_SCHEMA);
        filter.initialise();
        Assert.assertThat((Object)filter.getResourceResolver(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
    }

    @Test
    public void testValidateWithIncludes() throws Exception {
        SchemaValidationFilter filter = new SchemaValidationFilter();
        filter.setSchemaLocations(INCLUDE_SCHEMA);
        filter.initialise();
        Assert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)((Object)((Object)this)).getClass().getResourceAsStream(VALID_XML_FILE), this.muleContext)), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)((Object)((Object)this)).getClass().getResourceAsStream(INVALID_XML_FILE), this.muleContext)), (Matcher)CoreMatchers.is((Object)false));
    }
}

