/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.xpath;

import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.module.xml.util.XMLUtils;
import org.mule.module.xml.xpath.JaxpXPathEvaluator;
import org.mule.module.xml.xpath.SaxonXpathEvaluator;
import org.mule.module.xml.xpath.XPathReturnType;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxpXPathEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private static final int NUMBER_OF_THREADS = 10000;
    private CountDownLatch latch = new CountDownLatch(10000);
    private final JaxpXPathEvaluator jaxpXPathEvaluator = new SaxonXpathEvaluator();
    private MuleEvent evenEvent;
    private MuleEvent oddEvent;
    private Node evenNode;
    private Node oddNode;
    private Exception exception = null;

    @Before
    public void setUp() throws Exception {
        InputStream payload = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-concurrency-xpath-evaluator-even.xml");
        this.evenEvent = JaxpXPathEvaluatorTestCase.getTestEvent((Object)payload);
        this.evenNode = XMLUtils.toDOMNode((Object)payload, (MuleEvent)this.evenEvent);
        payload = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("test-concurrency-xpath-evaluator-odd.xml");
        this.oddEvent = JaxpXPathEvaluatorTestCase.getTestEvent((Object)payload);
        this.oddNode = XMLUtils.toDOMNode((Object)payload, (MuleEvent)this.oddEvent);
    }

    @Test
    public void testEvaluate() throws Exception {
        for (int i = 0; i < 10000; ++i) {
            ConcurrencyTestRunner runner = new ConcurrencyTestRunner();
            Thread thread = new Thread(runner);
            thread.setName("Thread" + i);
            thread.start();
        }
        this.latch.await();
        Assert.assertThat((Object)this.exception, (Matcher)CoreMatchers.nullValue());
    }

    private int getIndex(String name) {
        return Integer.parseInt(name.substring(6));
    }

    private void verifyBandName(int index) {
        if (index % 2 == 0) {
            NodeList nodeList = (NodeList)this.jaxpXPathEvaluator.evaluate("songs/song/band/text()", this.evenNode, XPathReturnType.NODESET, this.evenEvent);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Assert.assertThat((Object)nodeList.item(i).getNodeValue(), (Matcher)CoreMatchers.is((Object)"The Beatles"));
            }
        } else {
            NodeList nodeList = (NodeList)this.jaxpXPathEvaluator.evaluate("songs/song/band/text()", this.oddNode, XPathReturnType.NODESET, this.oddEvent);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Assert.assertThat((Object)nodeList.item(i).getNodeValue(), (Matcher)CoreMatchers.is((Object)"Oasis"));
            }
        }
    }

    private void verifySongName(int index) {
        if (index % 2 == 0) {
            NodeList nodeList = (NodeList)this.jaxpXPathEvaluator.evaluate("songs/song/name/text()", this.evenNode, XPathReturnType.NODESET, this.evenEvent);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Assert.assertThat((Object)nodeList.item(i).getNodeValue(), (Matcher)CoreMatchers.is((Object)("Song" + (i + 1))));
            }
        } else {
            NodeList nodeList = (NodeList)this.jaxpXPathEvaluator.evaluate("songs/song/name/text()", this.oddNode, XPathReturnType.NODESET, this.oddEvent);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Assert.assertThat((Object)nodeList.item(i).getNodeValue(), (Matcher)CoreMatchers.is((Object)("Song" + (nodeList.getLength() - i))));
            }
        }
    }

    private class ConcurrencyTestRunner
    implements Runnable {
        private ConcurrencyTestRunner() {
        }

        @Override
        public void run() {
            block2: {
                String threadName = Thread.currentThread().getName();
                int index = JaxpXPathEvaluatorTestCase.this.getIndex(threadName);
                try {
                    JaxpXPathEvaluatorTestCase.this.verifyBandName(index);
                    JaxpXPathEvaluatorTestCase.this.verifySongName(index);
                }
                catch (Exception e) {
                    if (JaxpXPathEvaluatorTestCase.this.exception != null) break block2;
                    JaxpXPathEvaluatorTestCase.this.exception = e;
                }
            }
            JaxpXPathEvaluatorTestCase.this.latch.countDown();
        }
    }
}

