/*
 * Decompiled with CFR 0.152.
 */
package org.mule.el;

import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.IOUtils;

public class XPath1FallbackFunctionTestCase
extends FunctionalTestCase {
    private String payload;

    protected String getConfigFile() {
        return "xpath-function-test-config.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.payload = IOUtils.getResourceAsString((String)"cd-catalog.xml", ((Object)((Object)this)).getClass());
    }

    @Test
    public void getTitles() throws Exception {
        MuleEvent event = this.runFlow("getTitles", this.payload);
        this.assertTitleElements((List)event.getMessage().getPayload());
    }

    @Test
    public void getTitlesFromStream() throws Exception {
        MuleEvent event = this.runFlow("getTitlesFromStream", this.payload);
        junit.framework.Assert.assertTrue((boolean)(event.getMessage().getPayload() instanceof Document));
    }

    @Test
    public void getTitlesFromFlowVar() throws Exception {
        MuleEvent event = XPath1FallbackFunctionTestCase.getTestEvent((Object)this.payload);
        event.setFlowVariable("xml", (Object)this.payload);
        event = ((Flow)this.getFlowConstruct("getTitlesFromFlowVar")).process(event);
        List elements = (List)event.getFlowVariable("titles");
        this.assertTitlesCount(elements);
        Assert.assertSame((Object)this.payload, (Object)event.getMessage().getPayload());
    }

    @Test
    public void getTitlesFromCustomPayload() throws Exception {
        MuleEvent event = this.runFlow("getTitlesFromCustomPayload", this.payload);
        List documents = (List)event.getFlowVariable("titles");
        this.assertTitlesCount(documents);
        Assert.assertSame((Object)this.payload, (Object)event.getMessage().getPayload());
    }

    @Test(expected=MessagingException.class)
    public void emptyXPathExpression() throws Exception {
        this.runFlow("emptyXPathExpression", this.payload);
    }

    @Test(expected=MessagingException.class)
    public void noArgsAtAll() throws Exception {
        this.runFlow("noArgsAtAll", this.payload);
    }

    private void assertTitleElements(List<Element> elements) {
        this.assertTitlesCount(elements);
        for (Element element : elements) {
            junit.framework.Assert.assertEquals((String)"title", (String)element.getName());
        }
    }

    private void assertTitlesCount(List<?> elements) {
        junit.framework.Assert.assertNotNull(elements);
        junit.framework.Assert.assertEquals((int)26, (int)elements.size());
    }
}

