/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class TemplateParserTestCase
extends AbstractMuleContextTestCase {
    private static final String TEST_MULE_STRING_EXPRESSION_XML = "<xml><t2><tag1 attr1='blahattr1'>BLAH1</tag1><tag1 attr1='blahattr2'>BLAH2</tag1></t2></xml>";
    private MuleMessage message;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.message = new DefaultMuleMessage((Object)TEST_MULE_STRING_EXPRESSION_XML, muleContext);
    }

    @Test
    public void testXPathExpression() throws Exception {
        String result = (String)muleContext.getExpressionManager().evaluate("#[xpath:/xml/t2/tag1[@attr1='blahattr1']]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"BLAH1", (Object)result);
    }

    @Test
    public void testStringExpression() throws Exception {
        String result = (String)muleContext.getExpressionManager().evaluate("#[string:#[xpath:/xml/t2/tag1[@attr1='blahattr1']]]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"BLAH1", (Object)result);
    }

    @Test
    public void testXPathExpressionWithAsterisk() throws Exception {
        String result = (String)muleContext.getExpressionManager().evaluate("#[xpath:/xml/*/tag1[@attr1='blahattr1']]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"BLAH1", (Object)result);
    }

    @Test
    public void testStringExpressionWithAsterisk() throws Exception {
        String result = (String)muleContext.getExpressionManager().evaluate("#[string:#[xpath:/xml/*/tag1[@attr1='blahattr1']]]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"BLAH1", (Object)result);
    }

    @Test
    public void testStringExpressionDoParse() throws Exception {
        String result = muleContext.getExpressionManager().parse("#[xpath:/xml/*/tag1[@attr1='blahattr1']]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"BLAH1", (Object)result);
    }

    @Test
    public void testStringExpressionDoParseEmbedded() throws Exception {
        String result = muleContext.getExpressionManager().parse("#[xpath:/xml/*/tag1[@attr1='blahattr1']] foo #[xpath:/xml/*/tag1[@attr1='blahattr2']]", this.message);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"BLAH1 foo BLAH2", (Object)result);
    }
}

