/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.config;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.expression.RequiredValueException;
import org.mule.api.model.InvocationResult;
import org.mule.api.transport.PropertyScope;
import org.mule.impl.model.resolvers.AnnotatedEntryPointResolver;
import org.mule.module.xml.config.AnnotatedComponent;
import org.mule.module.xml.config.IllegalAnnotatedComponent;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathAnnotatedEntryPointResolverTestCase
extends AbstractMuleContextTestCase {
    public static final String TEST_PAYLOAD = "<foo><bar>4</bar><bar>8</bar></foo>";

    @Test
    public void testAnnotatedMethod() throws Exception {
        AnnotatedEntryPointResolver resolver = new AnnotatedEntryPointResolver();
        AnnotatedComponent component = new AnnotatedComponent();
        MuleEventContext context = XPathAnnotatedEntryPointResolverTestCase.getTestEventContext((Object)TEST_PAYLOAD);
        context.getMessage().setProperty("method", (Object)"doStuff", PropertyScope.INVOCATION);
        InvocationResult result = resolver.invoke((Object)component, context);
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        Assert.assertTrue((boolean)(result.getResult() instanceof Map));
        Map map = (Map)result.getResult();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)(map.get("foo") instanceof Element));
        Assert.assertTrue((boolean)((Boolean)map.get("isBarValue")));
        Assert.assertEquals((Object)"4", map.get("bar"));
    }

    @Test
    public void testAnnotatedMethod2() throws Exception {
        AnnotatedEntryPointResolver resolver = new AnnotatedEntryPointResolver();
        AnnotatedComponent component = new AnnotatedComponent();
        MuleEventContext context = XPathAnnotatedEntryPointResolverTestCase.getTestEventContext((Object)TEST_PAYLOAD);
        context.getMessage().setProperty("method", (Object)"doStuff2", PropertyScope.INVOCATION);
        InvocationResult result = resolver.invoke((Object)component, context);
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        Assert.assertTrue((boolean)(result.getResult() instanceof Map));
        Map map = (Map)result.getResult();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)(map.get("foo") instanceof Document));
        Assert.assertTrue((boolean)((Boolean)map.get("isBarValue")));
        Assert.assertEquals((Object)new Double(8.0), map.get("bar"));
    }

    @Test
    public void testAnnotatedMethod3() throws Exception {
        AnnotatedEntryPointResolver resolver = new AnnotatedEntryPointResolver();
        AnnotatedComponent component = new AnnotatedComponent();
        MuleEventContext context = XPathAnnotatedEntryPointResolverTestCase.getTestEventContext((Object)TEST_PAYLOAD);
        context.getMessage().setProperty("method", (Object)"doStuff3", PropertyScope.INVOCATION);
        InvocationResult result = resolver.invoke((Object)component, context);
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        Assert.assertTrue((boolean)(result.getResult() instanceof Map));
        Map map = (Map)result.getResult();
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)(map.get("foo") instanceof Node));
        Assert.assertTrue((boolean)(map.get("bar") instanceof NodeList));
        Assert.assertEquals((long)2L, (long)((NodeList)map.get("bar")).getLength());
    }

    @Test(expected=RequiredValueException.class)
    public void testAnnotatedMethodRequiredMissing() throws Exception {
        AnnotatedEntryPointResolver resolver = new AnnotatedEntryPointResolver();
        AnnotatedComponent component = new AnnotatedComponent();
        MuleEventContext context = XPathAnnotatedEntryPointResolverTestCase.getTestEventContext((Object)TEST_PAYLOAD);
        context.getMessage().setProperty("method", (Object)"doStuff4", PropertyScope.INVOCATION);
        resolver.invoke((Object)component, context);
    }

    @Test
    public void testAnnotatedMethodMissingNotRequired() throws Exception {
        AnnotatedEntryPointResolver resolver = new AnnotatedEntryPointResolver();
        AnnotatedComponent component = new AnnotatedComponent();
        MuleEventContext context = XPathAnnotatedEntryPointResolverTestCase.getTestEventContext((Object)TEST_PAYLOAD);
        context.getMessage().setProperty("method", (Object)"doStuff5", PropertyScope.INVOCATION);
        InvocationResult result = resolver.invoke((Object)component, context);
        Assert.assertEquals((Object)result.getState(), (Object)InvocationResult.State.SUCCESSFUL);
        Assert.assertTrue((boolean)(result.getResult() instanceof Map));
        Map map = (Map)result.getResult();
        Assert.assertEquals((long)1L, (long)map.size());
        Assert.assertNull(map.get("foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalAnnotatedMethod() throws Exception {
        AnnotatedEntryPointResolver resolver = new AnnotatedEntryPointResolver();
        IllegalAnnotatedComponent component = new IllegalAnnotatedComponent();
        MuleEventContext context = XPathAnnotatedEntryPointResolverTestCase.getTestEventContext((Object)TEST_PAYLOAD);
        resolver.invoke((Object)component, context);
    }
}

