/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.expression;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.dom.DOMDocument;
import org.dom4j.tree.DefaultDocument;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.jaxen.dom.DOMXPath;
import org.jaxen.dom4j.Dom4jXPath;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.xml.expression.XPathExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Text;

@SmallTest
public class XPathExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    private static final String EXPRESSION = "//isTest[test() = 'true']";
    private static final String OTHER_EXPRESSION = "//isNotTest[test = 'false']";

    @Test
    public void testXPathCache() throws JaxenException {
        XPathExpressionEvaluator xPathExpressionEvaluator = new XPathExpressionEvaluator();
        XPath xPathDOM1 = xPathExpressionEvaluator.getXPath(EXPRESSION, (Object)new DOMDocument());
        Assert.assertTrue((boolean)(xPathDOM1 instanceof DOMXPath));
        XPath xPathDOM2 = xPathExpressionEvaluator.getXPath(EXPRESSION, (Object)new DOMDocument());
        Assert.assertTrue((xPathDOM2 == xPathDOM1 ? 1 : 0) != 0);
        XPath xPathDom4j3 = xPathExpressionEvaluator.getXPath(EXPRESSION, (Object)new DefaultDocument());
        Assert.assertTrue((boolean)(xPathDom4j3 instanceof Dom4jXPath));
        Assert.assertTrue((xPathDOM1 != xPathDom4j3 ? 1 : 0) != 0);
        XPath xPathDOM3 = xPathExpressionEvaluator.getXPath(OTHER_EXPRESSION, (Object)new DOMDocument());
        Assert.assertTrue((xPathDOM1 != xPathDOM3 ? 1 : 0) != 0);
    }

    @Test
    public void testEmptyElement() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.newDocument();
        Text node = dom.createTextNode(null);
        XPathExpressionEvaluator xPathExpressionEvaluator = new XPathExpressionEvaluator();
        Object result = xPathExpressionEvaluator.extractResultFromNode((Object)node);
        Assert.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void textNotSeparated() throws Exception {
        String payload = IOUtils.getResourceAsString((String)"sswa2smtp.xml", ((Object)((Object)this)).getClass());
        Object value = muleContext.getExpressionManager().evaluate("#[xpath:/*/toAddress/text()]", XPathExpressionEvaluatorTestCase.getTestEvent((Object)payload));
        junit.framework.Assert.assertEquals((String)"XPath expression extracted the wrong value", (Object)"prachurya.barua@bt.com", (Object)value);
    }
}

