/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.jaxb;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.transformer.TransformerMessagingException;
import org.mule.construct.Flow;
import org.mule.module.xml.transformer.jaxb.JAXBUnmarshallerTransformer;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class JaxbSecurityTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    protected final String xmlWithEntities = "<?xml version=\"1.0\"?>\n<!DOCTYPE order [\n<!ELEMENT foo ANY >\n<!ENTITY xxe SYSTEM 'file:%s' >\n<!ENTITY lol \"0101\" >\n]>\n<Foo><bar>&xxe; &lol;</bar></Foo>";

    protected String getConfigFile() {
        return "jaxb-transformer-security.xml";
    }

    protected String getXmlWithEntities() {
        return String.format("<?xml version=\"1.0\"?>\n<!DOCTYPE order [\n<!ELEMENT foo ANY >\n<!ENTITY xxe SYSTEM 'file:%s' >\n<!ENTITY lol \"0101\" >\n]>\n<Foo><bar>&xxe; &lol;</bar></Foo>", IOUtils.getResourceAsUrl((String)"xxe-passwd.txt", ((Object)((Object)this)).getClass()).getPath());
    }

    protected MuleEvent createEvent() throws Exception {
        MuleEvent testEvent = JaxbSecurityTestCase.getTestEvent((Object)"Test Message");
        testEvent.getMessage().getDataType().setMimeType("application/xml");
        testEvent.getMessage().setPayload((Object)this.getXmlWithEntities());
        return testEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void externalEntitiesEnabled() throws Exception {
        try {
            System.setProperty("mule.xml.expandExternalEntities", "true");
            System.setProperty("mule.xml.expandInternalEntities", "true");
            MuleEvent testEvent = this.createEvent();
            MuleEvent response = ((Flow)this.getFlowConstruct("testFlow")).process(testEvent);
            String payload = response.getMessage().getPayloadAsString();
            MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.containsString((String)"secret"));
            MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.containsString((String)"0101"));
        }
        finally {
            System.clearProperty("mule.xml.expandExternalEntities");
            System.clearProperty("mule.xml.expandInternalEntities");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void expandsEntitiesEnabled() throws Exception {
        try {
            System.setProperty("mule.xml.expandInternalEntities", "true");
            MuleEvent testEvent = this.createEvent();
            MuleEvent response = ((Flow)this.getFlowConstruct("testFlow")).process(testEvent);
            String payload = response.getMessage().getPayloadAsString();
            MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"secret")));
            MatcherAssert.assertThat((Object)payload, (Matcher)Matchers.containsString((String)"0101"));
        }
        finally {
            System.clearProperty("mule.xml.expandInternalEntities");
        }
    }

    @Test
    public void expandsEntitiesDisabled() throws Exception {
        try {
            MuleEvent testEvent = this.createEvent();
            MuleEvent response = ((Flow)this.getFlowConstruct("testFlow")).process(testEvent);
            String payload = response.getMessage().getPayloadAsString();
            Assert.fail((String)"Should've thrown exception");
        }
        catch (TransformerMessagingException e) {
            MatcherAssert.assertThat((Object)e.getTransformer(), (Matcher)Matchers.instanceOf(JAXBUnmarshallerTransformer.class));
        }
    }
}

