/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMWriter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.module.xml.transformer.XmlToDomDocument;
import org.mule.module.xml.util.XMLTestUtils;
import org.mule.module.xml.util.XMLUtils;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.transformers.xml.AbstractDomXmlTransformersTestCase;
import org.mule.util.IOUtils;
import org.w3c.dom.Node;

public class DomToXmlWithNegativeProperty
extends AbstractDomXmlTransformersTestCase {
    @Rule
    public final SystemProperty maxAttributeSizeProperty = new SystemProperty("mule.xml.maxAttributeSize", "-500000");

    @Before
    public void doSetUp() throws IOException, DocumentException {
        this.setTestData(IOUtils.getResourceAsString((String)"small.xml", ((Object)((Object)this)).getClass()));
        Document dom4jDoc = DocumentHelper.parseText((String)((String)this.getTestData()));
        this.setResultData(new DOMWriter().write(dom4jDoc));
    }

    @Test
    public void invalidMaxAttributeSizeProperty() throws Exception {
        Object expectedResult = this.getResultData();
        MatcherAssert.assertThat((Object)expectedResult, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        XmlToDomDocument transformer = (XmlToDomDocument)this.getTransformer();
        InputStream is = IOUtils.getResourceAsStream((String)"small.xml", XMLTestUtils.class);
        XMLInputFactory xmlInputFactory = transformer.getXMLInputFactory();
        XMLStreamReader sr = XMLUtils.toXMLStreamReader((XMLInputFactory)xmlInputFactory, (Object)is);
        MatcherAssert.assertThat((Object)((WstxInputFactory)xmlInputFactory).getConfig().getMaxAttributeSize(), (Matcher)CoreMatchers.is((Object)Integer.MAX_VALUE));
        Object result = transformer.transform((Object)sr);
        DomToXmlWithNegativeProperty.writeXml((Node)result);
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)this.compareResults(expectedResult, result), (Matcher)CoreMatchers.is((Object)true));
    }
}

