/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMWriter;
import org.mule.api.transformer.Transformer;
import org.mule.module.xml.transformer.XmlToDomDocument;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformers.xml.DomXmlTransformerEncodingTestCase;
import org.mule.util.IOUtils;

public class DomXmlTransformerEncodingByteArrayTestCase
extends DomXmlTransformerEncodingTestCase {
    private byte[] srcData;
    private String resultData;

    @Override
    protected void doSetUp() throws Exception {
        InputStream resourceStream = IOUtils.getResourceAsStream((String)"cdcatalog-utf-8.xml", ((Object)((Object)this)).getClass());
        this.srcData = IOUtils.toString((InputStream)resourceStream, (String)"UTF-8").getBytes("UTF-8");
        resourceStream = IOUtils.getResourceAsStream((String)"cdcatalog-us-ascii.xml", ((Object)((Object)this)).getClass());
        this.resultData = IOUtils.toString((InputStream)resourceStream, (String)"US-ASCII");
    }

    @Override
    public Transformer getRoundTripTransformer() throws Exception {
        XmlToDomDocument trans = (XmlToDomDocument)this.createObject(XmlToDomDocument.class);
        trans.setReturnDataType(DataTypeFactory.create(byte[].class));
        return trans;
    }

    @Override
    public Object getTestData() {
        return this.srcData;
    }

    @Override
    public Object getResultData() {
        return this.resultData;
    }

    @Override
    public boolean compareResults(Object expected, Object result) {
        try {
            if (expected instanceof byte[]) {
                Document dom4jDoc = null;
                dom4jDoc = DocumentHelper.parseText((String)new String((byte[])expected, "UTF-8"));
                expected = new DOMWriter().write(dom4jDoc);
                dom4jDoc = DocumentHelper.parseText((String)new String((byte[])result, "UTF-8"));
                result = new DOMWriter().write(dom4jDoc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.compareResults(expected, result);
    }
}

