/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMWriter;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.xml.transformer.XmlToDomDocument;
import org.mule.module.xml.util.XMLTestUtils;
import org.mule.module.xml.util.XMLUtils;
import org.mule.transformers.xml.AbstractDomXmlTransformersTestCase;
import org.mule.util.IOUtils;
import org.w3c.dom.Node;

public class DomXmlTransformersTestCase
extends AbstractDomXmlTransformersTestCase {
    protected void doSetUp() throws Exception {
        this.srcData = IOUtils.getResourceAsString((String)"cdcatalog.xml", ((Object)((Object)this)).getClass());
        Document dom4jDoc = DocumentHelper.parseText((String)this.srcData);
        this.resultData = new DOMWriter().write(dom4jDoc);
    }

    @Test
    public void testTransformXMLStreamReader() throws Exception {
        Object expectedResult = this.getResultData();
        Assert.assertNotNull((Object)expectedResult);
        XmlToDomDocument transformer = (XmlToDomDocument)this.getTransformer();
        InputStream is = IOUtils.getResourceAsStream((String)"cdcatalog.xml", XMLTestUtils.class);
        XMLStreamReader sr = XMLUtils.toXMLStreamReader((XMLInputFactory)transformer.getXMLInputFactory(), (Object)is);
        Object result = transformer.transform((Object)sr);
        DomXmlTransformersTestCase.writeXml((Node)result);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((String)("expected: " + expectedResult + "\nresult: " + result), (boolean)this.compareResults(expectedResult, result));
    }

    @Test
    public void testAllXmlMessageTypes() throws Exception {
        List<?> list = XMLTestUtils.getXmlMessageVariants("cdcatalog.xml");
        Iterator<?> it = list.iterator();
        Object expectedResult = this.getResultData();
        Assert.assertNotNull((Object)expectedResult);
        while (it.hasNext()) {
            Object msg = it.next();
            Object result = this.getTransformer().transform(msg);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((String)("Test failed for message type: " + msg.getClass()), (boolean)this.compareResults(expectedResult, result));
        }
    }
}

