/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.transformer.Transformer;
import org.mule.module.xml.transformer.XsltTransformer;
import org.mule.module.xml.util.XMLTestUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transformers.xml.AbstractXmlTransformerTestCase;
import org.mule.util.IOUtils;

public class InlineXsltTransformerTestCase
extends AbstractXmlTransformerTestCase {
    private String srcData;
    private String resultData;

    protected void doSetUp() throws Exception {
        this.srcData = IOUtils.getResourceAsString((String)"simple.xml", ((Object)((Object)this)).getClass());
        this.resultData = IOUtils.getResourceAsString((String)"simple-out.xml", ((Object)((Object)this)).getClass());
    }

    public Transformer getTransformer() throws Exception {
        XsltTransformer transformer = new XsltTransformer();
        transformer.setXslt("<?xml version='1.0'?>\n<xsl:stylesheet version='2.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>\n<xsl:output method='xml'/>\n<xsl:template match='/'>\n  <some-xml>\n    <xsl:copy-of select='.'/>\n  </some-xml>\n</xsl:template>\n</xsl:stylesheet>");
        transformer.setReturnDataType(DataTypeFactory.STRING);
        transformer.setMuleContext(muleContext);
        transformer.initialise();
        return transformer;
    }

    public Transformer getRoundTripTransformer() throws Exception {
        return null;
    }

    public void testRoundtripTransform() throws Exception {
    }

    public Object getTestData() {
        return this.srcData;
    }

    public Object getResultData() {
        return this.resultData;
    }

    @Test
    public void testAllXmlMessageTypes() throws Exception {
        List<?> list = XMLTestUtils.getXmlMessageVariants("simple.xml");
        Iterator<?> it = list.iterator();
        Object expectedResult = this.getResultData();
        Assert.assertNotNull((Object)expectedResult);
        while (it.hasNext()) {
            Object msg = it.next();
            if (msg instanceof XMLStreamReader) continue;
            Object result = this.getTransformer().transform(msg);
            Assert.assertNotNull((Object)result);
            Assert.assertTrue((String)("Test failed for message type: " + msg.getClass()), (boolean)this.compareResults(expectedResult, result));
        }
    }
}

