/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml;

import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.module.xml.transformer.ObjectToXml;
import org.mule.module.xml.transformer.XmlToObject;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;

public class XmlMuleMessageTransformersTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testMessageSerialization() throws Exception {
        ObjectToXml t1 = (ObjectToXml)this.createObject(ObjectToXml.class);
        t1.setAcceptMuleMessage(true);
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"test", muleContext);
        msg.setEncoding("UTF-8");
        msg.setCorrelationId("1234");
        msg.setInvocationProperty("number", (Object)1);
        msg.setOutboundProperty("object", (Object)new Apple());
        msg.setOutboundProperty("string", (Object)"hello");
        String xml = (String)t1.transform((Object)msg);
        Assert.assertNotNull((Object)xml);
        XmlToObject t2 = (XmlToObject)this.createObject(XmlToObject.class);
        Object result = t2.transform((Object)xml);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessage));
        msg = (MuleMessage)result;
        Assert.assertEquals((Object)"test", (Object)msg.getPayloadAsString());
        Assert.assertEquals((Object)new Apple(), (Object)msg.getOutboundProperty("object"));
        Assert.assertEquals((Object)new Apple(), (Object)msg.getOutboundProperty("oBjeCt"));
        Assert.assertNull((Object)msg.getInboundProperty("oBjeCt"));
        Assert.assertNull((Object)msg.getInvocationProperty("oBjeCt"));
        Assert.assertNull((Object)msg.getSessionProperty("oBjeCt"));
        Assert.assertEquals((Object)"hello", (Object)msg.getOutboundProperty("string"));
        Assert.assertEquals((Object)"hello", (Object)msg.getOutboundProperty("String"));
        Assert.assertNull((Object)msg.getInboundProperty("string"));
        Assert.assertNull((Object)msg.getInvocationProperty("string"));
        Assert.assertNull((Object)msg.getSessionProperty("string"));
        Assert.assertEquals((long)1L, (long)((Integer)msg.getInvocationProperty("number")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)msg.getInvocationProperty("NUMBER")).intValue());
        Assert.assertNull((Object)msg.getInboundProperty("number"));
        Assert.assertNull((Object)msg.getOutboundProperty("number"));
        Assert.assertNull((Object)msg.getSessionProperty("number"));
        Assert.assertEquals((Object)"1234", (Object)msg.getCorrelationId());
        Assert.assertEquals((Object)"UTF-8", (Object)msg.getEncoding());
        Assert.assertEquals((long)1L, (long)msg.getInvocationPropertyNames().size());
        Set outboundProps = msg.getOutboundPropertyNames();
        Assert.assertEquals((long)3L, (long)outboundProps.size());
        outboundProps.remove("MULE_CORRELATION_ID");
        outboundProps.remove("MULE_ENCODING");
        for (String key : outboundProps) {
            Assert.assertTrue((key.equals("number") || key.equals("string") || key.equals("object") ? 1 : 0) != 0);
            Assert.assertFalse((key.equals("NUMBER") || key.equals("STRING") || key.equals("OBJECT") ? 1 : 0) != 0);
        }
    }
}

