/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.xml.xslt;

import java.io.File;
import net.sf.saxon.Controller;
import net.sf.saxon.jaxp.TransformerImpl;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.api.MuleEvent;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transformers.xml.xslt.TestTransformerFactoryImpl;
import org.mule.util.FileUtils;
import org.mule.util.IOUtils;
import org.mule.util.UUID;

public abstract class XsltResultDocumentTestCase
extends FunctionalTestCase {
    private static final String INPUT_FILE = "cities.xml";
    private static final String OUTPUT_FILE_PROPERTY = "outputFile";
    private static final String FLOW_NAME = "listCities";
    private static final String EXPECTED_OUTPUT = "italy - milan - 5 | france - paris - 7 | germany - munich - 4 | france - lyon - 2 | italy - venice - 1 | ";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    protected String getConfigFile() {
        return "xsl/xslt-result-document-config.xml";
    }

    @Test
    public void writeToSameFileSeveralTimes() throws Exception {
        String cities = IOUtils.getResourceAsString((String)INPUT_FILE, ((Object)((Object)this)).getClass());
        File outputFile = this.temporaryFolder.newFile(UUID.getUUID());
        this.executeFlowAndValidateOutput(cities, outputFile);
        this.executeFlowAndValidateOutput(cities, outputFile);
        this.verifyControllerReset();
    }

    private void verifyControllerReset() {
        String resetControllerAfterEachTransformationProperty = System.getProperty("mule.xml.resetControllerAfterEachTransformation", "false");
        boolean resetControllerAfterEachTransformation = Boolean.parseBoolean(resetControllerAfterEachTransformationProperty);
        if (resetControllerAfterEachTransformation) {
            Controller controller = ((TransformerImpl)TestTransformerFactoryImpl.TRANSFORMER).getUnderlyingController();
            if (resetControllerAfterEachTransformation) {
                Assert.assertThat((Object)controller.getGlobalContextItem(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            } else {
                Assert.assertThat((Object)controller.getGlobalContextItem(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
            }
        }
    }

    private void executeFlowAndValidateOutput(String payload, File outputFile) throws Exception {
        FileUtils.deleteFile((File)outputFile);
        this.runFlow(FLOW_NAME, this.createEventWithPayloadAndSessionProperty(payload, OUTPUT_FILE_PROPERTY, outputFile.getAbsolutePath()));
        Assert.assertThat((Object)FileUtils.readFileToString((File)outputFile), (Matcher)CoreMatchers.is((Object)EXPECTED_OUTPUT));
    }

    private MuleEvent createEventWithPayloadAndSessionProperty(Object payload, String propertyName, Object propertyValue) throws Exception {
        MuleEvent muleEvent = XsltResultDocumentTestCase.getTestEvent((Object)payload);
        muleEvent.getMessage().setProperty(propertyName, propertyValue, PropertyScope.SESSION);
        return muleEvent;
    }
}

