/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.check.internal.SizeAwareTypes;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.MinSize;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotEmpty;
import org.apache.commons.lang.ObjectUtils;

public class Lists {
    public static <A> void addAfter(@NonNull List<A> list, A element, A reference) {
        ListIterator<A> iter = list.listIterator();
        while (iter.hasNext()) {
            if (!ObjectUtils.equals(iter.next(), reference)) continue;
            iter.add(element);
            return;
        }
        throw new NoSuchElementException(reference.toString());
    }

    public static <A> void addBefore(@NonNull List<A> list, A element, A reference) {
        ListIterator<A> iter = list.listIterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(reference)) continue;
            iter.previous();
            iter.add(element);
            return;
        }
        throw new NoSuchElementException(reference.toString());
    }

    public static <A> A removeLast(@NonNull List<A> list) {
        return list.remove(list.size() - 1);
    }

    public static <A> A first(@NotEmpty List<A> list) {
        Ensure.that().isNotEmpty("var0", list);
        return list.get(0);
    }

    public static <A> A second(@MinSize(value=2) List<A> list) {
        Ensure.that().isMinSize("var0", list, 2, SizeAwareTypes.COLLECTION);
        return list.get(1);
    }

    public static <A> A third(@MinSize(value=3) List<A> list) {
        Ensure.that().isMinSize("var0", list, 3, SizeAwareTypes.COLLECTION);
        return list.get(2);
    }

    public static <A> A last(@NotEmpty List<A> list) {
        Ensure.that().isNotEmpty("var0", list);
        return list.get(list.size() - 1);
    }

    @Constant
    public static <A> Class<List<A>> type() {
        return List.class;
    }

    public static <A> List<A> from(A ... elements) {
        return Collections.unmodifiableList(Arrays.asList(elements));
    }
}

