/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.staccatocommons.collections.iterable.Iterables;
import net.sf.staccatocommons.lang.MapBuilder;
import net.sf.staccatocommons.lang.Option;
import net.sf.staccatocommons.lang.tuple.Pair;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Maps {
    @NonNull
    public static <V> Option<V> get(@NonNull Map<?, V> map, Object key) {
        V value = map.get(key);
        if (value != null) {
            return (Option)Option.some(value);
        }
        if (map.containsKey(key)) {
            return (Option)Option.someNull();
        }
        return (Option)Option.none();
    }

    @NonNull
    public static <V> V getExistent(@NonNull Map<?, V> map, Object key) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        if (map.containsKey(key)) {
            return null;
        }
        throw new NoSuchElementException("No entry found for key " + key);
    }

    @NonNull
    public static <K> Option<K> anyKey(@NonNull Map<K, ?> map) {
        if (map.isEmpty()) {
            return (Option)Option.none();
        }
        return (Option)Option.some(Iterables.any((Iterable)map.keySet()));
    }

    public static <K> K anyKeyOrNull(@NonNull Map<K, ?> map) {
        if (map.isEmpty()) {
            return null;
        }
        return (K)Iterables.any((Iterable)map.keySet());
    }

    @NonNull
    public static <V> Option<V> anyValue(@NonNull Map<?, V> map) {
        if (map.isEmpty()) {
            return (Option)Option.none();
        }
        return (Option)Option.some(Iterables.any((Iterable)map.values()));
    }

    public static <V> V anyValueOrNull(@NonNull Map<?, V> map) {
        if (map.isEmpty()) {
            return null;
        }
        return (V)Iterables.any((Iterable)map.values());
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static <K, V> Map<K, V> from(Iterable<Pair<K, V>> entries) {
        MapBuilder b = MapBuilder.from(new LinkedHashMap());
        for (Pair<K, V> p : entries) {
            b.with(p);
        }
        return b.build();
    }

    public static <K, V> Map<K, V> from(Pair<K, V> ... entries) {
        return Maps.from((Iterable)Arrays.asList(entries));
    }
}

