/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.check.Validate;
import net.sf.staccatocommons.collections.internal.ToPair;
import net.sf.staccatocommons.collections.internal.iterator.DropIterator;
import net.sf.staccatocommons.collections.internal.iterator.FilterIndexIterator;
import net.sf.staccatocommons.collections.internal.iterator.FilterIterator;
import net.sf.staccatocommons.collections.internal.iterator.TakeWhileIterator;
import net.sf.staccatocommons.collections.iterable.Iterables;
import net.sf.staccatocommons.collections.iterable.internal.IterablesInternal;
import net.sf.staccatocommons.collections.stream.AbstractDelayedDeconsApplicable;
import net.sf.staccatocommons.collections.stream.AbstractStream;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.Streams;
import net.sf.staccatocommons.collections.stream.Transformable;
import net.sf.staccatocommons.collections.stream.impl.ListStream;
import net.sf.staccatocommons.collections.stream.impl.fold.internal.Reduction;
import net.sf.staccatocommons.collections.stream.impl.fold.internal.Reductions;
import net.sf.staccatocommons.collections.stream.impl.internal.AppendIterableStream;
import net.sf.staccatocommons.collections.stream.impl.internal.AppendStream;
import net.sf.staccatocommons.collections.stream.impl.internal.DeconsTransformStream;
import net.sf.staccatocommons.collections.stream.impl.internal.DropWhileStream;
import net.sf.staccatocommons.collections.stream.impl.internal.FlatMapStream;
import net.sf.staccatocommons.collections.stream.impl.internal.MapStream;
import net.sf.staccatocommons.collections.stream.impl.internal.MemorizedStream;
import net.sf.staccatocommons.collections.stream.impl.internal.PrependStream;
import net.sf.staccatocommons.collections.stream.impl.internal.SortedStream;
import net.sf.staccatocommons.collections.stream.impl.internal.TakeStream;
import net.sf.staccatocommons.collections.stream.impl.internal.TransformStream;
import net.sf.staccatocommons.collections.stream.impl.internal.ZipStream;
import net.sf.staccatocommons.collections.stream.impl.internal.delayed.DelayedAppendStream;
import net.sf.staccatocommons.collections.stream.impl.internal.delayed.DelayedDeconsTransformStream;
import net.sf.staccatocommons.collections.stream.impl.internal.delayed.DelayedPrependStream;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Applicable2;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.defs.Evaluable2;
import net.sf.staccatocommons.defs.Executable;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.function.Function2;
import net.sf.staccatocommons.defs.predicate.Predicate2;
import net.sf.staccatocommons.defs.type.NumberType;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.lang.Compare;
import net.sf.staccatocommons.lang.Option;
import net.sf.staccatocommons.lang.function.AbstractFunction;
import net.sf.staccatocommons.lang.function.AbstractFunction2;
import net.sf.staccatocommons.lang.function.Functions;
import net.sf.staccatocommons.lang.internal.ToString;
import net.sf.staccatocommons.lang.predicate.AbstractPredicate2;
import net.sf.staccatocommons.lang.predicate.Equiv;
import net.sf.staccatocommons.lang.predicate.Predicates;
import net.sf.staccatocommons.lang.tuple.Pair;
import net.sf.staccatocommons.lang.tuple.Tuples;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotNegative;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractStream<A>
implements Stream<A> {
    protected static final Validate<NoSuchElementException> VALIDATE_ELEMENT;
    private static final Predicate2 EQUAL_OR_EQUIV;
    private static final Function TO_ITERABLE;

    static {
        EQUAL_OR_EQUIV = AbstractStream.equalOrEquivInitializer();
        TO_ITERABLE = AbstractStream.toIterableInitializer();
        VALIDATE_ELEMENT = Validate.throwing(NoSuchElementException.class);
    }

    public int size() {
        int size = 0;
        Thriter iter = (Thriter)this.iterator();
        while (iter.hasNext()) {
            iter.advanceNext();
            ++size;
        }
        return size;
    }

    public boolean isEmpty() {
        return this.iterator().isEmpty();
    }

    @Override
    public void each(Executable<? super A> block) {
        for (Object element : this) {
            block.exec(element);
        }
    }

    public boolean contains(A element) {
        return IterablesInternal.containsInternal(this, element);
    }

    @Override
    public Stream<A> filter(Evaluable<? super A> predicate) {
        return Streams.from(new FilterIterator<A>((Iterator)this.iterator(), predicate));
    }

    @Override
    public Stream<A> skip(A element) {
        return this.filter((Evaluable)Predicates.equal(element).not());
    }

    @Override
    public Stream<A> takeWhile(Evaluable<? super A> predicate) {
        return Streams.from(new TakeWhileIterator<A>((Iterator)this.iterator(), predicate));
    }

    @Override
    public Stream<A> take(@NotNegative int amountOfElements) {
        Ensure.that().isNotNegative("var0", amountOfElements);
        return new TakeStream((Thriter)this.iterator(), amountOfElements);
    }

    @Override
    public Stream<A> dropWhile(Evaluable<? super A> predicate) {
        return new DropWhileStream<A>(this, predicate);
    }

    @Override
    public Stream<A> drop(@NotNegative int amountOfElements) {
        Ensure.that().isNotNegative("var0", amountOfElements);
        return Streams.from(new DropIterator(amountOfElements, (Thriter)this.iterator()));
    }

    @Override
    public A reduce(Applicable2<? super A, ? super A, ? extends A> function) {
        try {
            return Iterables.reduce(this, function);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (A)VALIDATE_ELEMENT.fail("Can not reduce an empty stream", new Object[0]);
        }
    }

    @Override
    public <O> O fold(O initial, Applicable2<? super O, ? super A, ? extends O> function) {
        return Iterables.fold(this, initial, function);
    }

    @Override
    public A any() {
        return Iterables.any(this);
    }

    @Override
    public Option<A> anyOrNone() {
        return Iterables.anyOrNone(this);
    }

    @Override
    public A anyOrNull() {
        return (A)this.anyOrNone().valueOrNull();
    }

    @Override
    public A anyOrElse(Thunk<A> thunk) {
        return (A)this.anyOrNone().valueOrElse(thunk);
    }

    @Override
    public A anyOrElse(A value) {
        return (A)this.anyOrNone().valueOrElse(value);
    }

    @Override
    public A find(Evaluable<? super A> predicate) {
        return Iterables.find(this, predicate);
    }

    @Override
    public Option<A> findOrNone(Evaluable<? super A> predicate) {
        return Iterables.findOrNone(this, predicate);
    }

    @Override
    public A findOrNull(Evaluable<? super A> predicate) {
        return (A)this.findOrNone(predicate).valueOrNull();
    }

    @Override
    public A findOrElse(Evaluable<? super A> predicate, Thunk<? extends A> thunk) {
        return (A)this.findOrNone(predicate).valueOrElse(thunk);
    }

    @Override
    public A findOrElse(Evaluable<? super A> predicate, A element) {
        return (A)this.findOrNone(predicate).valueOrElse(element);
    }

    @Override
    public boolean all(Evaluable<? super A> predicate) {
        return Iterables.all(this, predicate);
    }

    @Override
    public boolean allEquiv() {
        return Iterables.allEqual(this);
    }

    @Override
    public boolean allEquivBy(Evaluable2<? super A, ? super A> equivTest) {
        return Iterables.allEquivBy(this, equivTest);
    }

    @Override
    public boolean any(Evaluable<? super A> predicate) {
        return Iterables.any(this, predicate);
    }

    @Override
    public <B> Stream<B> map(Function<? super A, ? extends B> function) {
        return new MapStream<A, B>(this, function);
    }

    @Override
    public <B> Stream<B> flatMap(Function<? super A, ? extends Iterable<? extends B>> function) {
        return new FlatMapStream(this, function);
    }

    @Override
    public <B> Stream<B> flatMapArray(@NonNull Function<? super A, ? extends B[]> function) {
        return this.flatMap(AbstractStream.toIterable().of(function));
    }

    @Override
    public Stream<A> append(Iterable<A> other) {
        return new AppendIterableStream<A>(this, other);
    }

    @Override
    public Stream<A> appendUndefined() {
        return this.append((A)Streams.undefined());
    }

    @Override
    public A first() {
        return this.get(0);
    }

    @Override
    public A second() {
        return this.get(1);
    }

    @Override
    public A third() {
        return this.get(2);
    }

    @Override
    public A last() {
        Thriterator iter = this.iterator();
        VALIDATE_ELEMENT.that(iter.hasNext(), "Empty streams have no elements", new Object[0]);
        while (iter.hasNext()) {
            iter.advanceNext();
        }
        return (A)iter.current();
    }

    @Override
    public A get(int n) {
        Thriterator iter = this.iterator();
        int i = 0;
        while (i <= n) {
            try {
                iter.advanceNext();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IndexOutOfBoundsException("At " + n);
            }
            ++i;
        }
        return (A)iter.current();
    }

    @Override
    public final Stream<A> filterIndex(Evaluable<Integer> predicate) {
        return Streams.from(new FilterIndexIterator((Iterator)this.iterator(), predicate));
    }

    @Override
    public final Stream<A> skipIndex(int index) {
        return this.filterIndex((Evaluable<Integer>)((Evaluable)Predicates.equal((Object)index).not()));
    }

    @Override
    public int indexOf(A element) {
        return Iterables.indexOf(this, element);
    }

    @Override
    public final int positionOf(A element) {
        int index = this.indexOf(element);
        if (index == -1) {
            throw new NoSuchElementException(element.toString());
        }
        return index;
    }

    @Override
    public boolean isBefore(A previous, A next) {
        return Iterables.isBefore(this, previous, next);
    }

    @Override
    public Set<A> toSet() {
        return Iterables.toSet(this);
    }

    @Override
    public List<A> toList() {
        return Iterables.toList(this);
    }

    @Override
    public Stream<A> force() {
        return new ListStream<A>(this.toList()){

            @Override
            public List<A> toList() {
                return Collections.unmodifiableList(this.getList());
            }
        };
    }

    @Override
    public Stream<A> memorize() {
        return new MemorizedStream(this.iterator());
    }

    @Override
    public A[] toArray(Class<? super A> clazz) {
        return this.toArray(clazz, this.toList());
    }

    protected A[] toArray(Class<? super A> clazz, Collection<A> readOnlyColView) {
        return readOnlyColView.toArray((Object[])Array.newInstance(clazz, readOnlyColView.size()));
    }

    @Override
    @ForceRestrictions
    public String joinStrings(@NonNull String separator) {
        Ensure.isNotNull((String)"var0", (Object)separator);
        return StringUtils.join((Iterator)((Iterator)this.iterator()), (String)separator);
    }

    @Override
    public Pair<List<A>, List<A>> partition(Evaluable<? super A> predicate) {
        return Iterables.partition(this, predicate);
    }

    @Override
    public final Pair<Stream<A>, Stream<A>> streamPartition(Evaluable<? super A> predicate) {
        Pair<List<? super A>, List<? super A>> partition = this.partition(predicate);
        return Tuples._(Streams.from((List)partition._0()), Streams.from((List)partition._1()));
    }

    @Override
    public final boolean equiv(A ... elements) {
        return this.equiv((Iterable)Arrays.asList(elements));
    }

    @Override
    public boolean equiv(Iterable<? extends A> other) {
        return this.equivBy((Evaluable2)AbstractStream.equalOrEquiv(), other);
    }

    @Constant
    private static <A> Predicate2<A, A> equalOrEquiv() {
        return EQUAL_OR_EQUIV;
    }

    @Override
    public boolean equivBy(Evaluable2<? super A, ? super A> equalty, Iterable<? extends A> other) {
        return Iterables.equivBy(this, other, equalty);
    }

    @Override
    public final boolean equivBy(Evaluable2<? super A, ? super A> equalityTest, A ... elements) {
        return this.equivBy(equalityTest, (Iterable)Arrays.asList(elements));
    }

    @Override
    public final <B> boolean equivOn(Applicable<? super A, ? extends B> function, Iterable<? extends A> iterable) {
        return this.equivBy((Evaluable2)Equiv.on(function), iterable);
    }

    @Override
    public final <B> boolean equivOn(Applicable<? super A, ? extends B> function, A ... elements) {
        return this.equivOn(function, (Iterable)Arrays.asList(elements));
    }

    @Override
    public <B> Stream<B> transform(Applicable<Stream<A>, ? extends Stream<B>> function) {
        return new TransformStream(this, function);
    }

    @Override
    public Stream<A> intersperse(final A sep) {
        return this.transform(new AbstractDelayedDeconsApplicable<A, A>(){

            @Override
            public Stream<A> apply(Thunk<A> head, Stream<A> tail) {
                if (tail.isEmpty()) {
                    return Streams.cons(head);
                }
                return Streams.cons(head, Streams.cons(sep, tail.intersperse(sep)));
            }
        });
    }

    @Override
    public Stream<A> append(A element) {
        return new AppendStream<A>(this, element);
    }

    @Override
    public Stream<A> append(Thunk<A> element) {
        return new DelayedAppendStream<A>(this, element);
    }

    @Override
    public Stream<A> prepend(A element) {
        return new PrependStream<A>(element, this);
    }

    @Override
    public Stream<A> prepend(Thunk<A> element) {
        return new DelayedPrependStream<A>(element, this);
    }

    @Override
    public <B> Stream<B> transform(Transformable.DeconsApplicable<A, B> function) {
        return new DeconsTransformStream<B, A>(this, function);
    }

    @Override
    public <B> Stream<B> transform(Transformable.DelayedDeconsApplicable<A, B> function) {
        return new DelayedDeconsTransformStream<A, B>(this, function);
    }

    @Override
    public <B> Stream<Pair<A, B>> zip(Iterable<B> iterable) {
        return this.zip(iterable, (Function2)ToPair.getInstance());
    }

    @Override
    public Pair<A, Stream<A>> decons() {
        Iterator iter = (Iterator)this.iterator();
        VALIDATE_ELEMENT.that(iter.hasNext(), "Empty streams can not be deconstructed", new Object[0]);
        return Tuples._(iter.next(), Streams.from(iter));
    }

    @Override
    public Pair<Thunk<A>, Stream<A>> delayedDecons() {
        Thriterator iter = this.iterator();
        VALIDATE_ELEMENT.that(iter.hasNext(), "Empty streams can not be deconstructed", new Object[0]);
        return Tuples._((Object)iter.delayedNext(), Streams.from(iter));
    }

    @Override
    public Stream<A> tail() {
        VALIDATE_ELEMENT.that(!this.isEmpty(), "Empty streams have not tail", new Object[0]);
        return this.drop(1);
    }

    @Override
    public A head() {
        try {
            return this.first();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return (A)VALIDATE_ELEMENT.fail("Empty streams have no head", new Object[0]);
        }
    }

    @Override
    @ForceRestrictions
    public <B, C> Stream<C> zip(@NonNull Iterable<B> iterable, @NonNull Function2<A, B, C> function) {
        Ensure.isNotNull((String)"var1", function);
        Ensure.isNotNull((String)"var0", iterable);
        return new ZipStream<C, A, B>(this, iterable, function);
    }

    @Override
    public A sum(NumberType<A> numberType) {
        return Iterables.sum(this, numberType);
    }

    @Override
    public A product(NumberType<A> numberType) {
        return Iterables.product(this, numberType);
    }

    @Override
    public A average(final NumberType<A> numberType) {
        class Ref {
            A val;
            final /* synthetic */ AbstractStream this$0;

            Ref(AbstractStream abstractStream, NumberType numberType) {
                this.this$0 = abstractStream;
                this.val = numberType.zero();
            }
        }
        final Ref size = new Ref(this, numberType);
        return (A)numberType.divide(this.fold((O)numberType.zero(), (Applicable2<? super O, ? super A, ? extends O>)((Applicable2)new AbstractFunction2<A, A, A>(){
            {
            }

            public A apply(A arg0, A arg1) {
                size.val = numberType.increment(size.val);
                return numberType.add(arg0, arg1);
            }
        })), size.val);
    }

    @Override
    public A maximum() {
        return this.maximumBy(this.natural());
    }

    @Override
    public A minimum() {
        return this.minimumBy(this.natural());
    }

    @Override
    public A maximumBy(Comparator<? super A> comparator) {
        return this.reduce((Applicable2)Compare.max(comparator));
    }

    @Override
    public A minimumBy(Comparator<? super A> comparator) {
        return this.reduce((Applicable2)Compare.min(comparator));
    }

    @Override
    public final <B extends Comparable<B>> A maximumOn(Applicable<? super A, B> function) throws NoSuchElementException {
        return this.maximumBy(Compare.on(function));
    }

    @Override
    public final <B extends Comparable<B>> A minimumOn(Applicable<? super A, B> function) throws NoSuchElementException {
        return this.minimumBy(Compare.on(function));
    }

    @Override
    public Stream<A> sort() {
        return this.sortBy(this.natural());
    }

    @Override
    public Stream<A> sortBy(Comparator<A> comparator) {
        return new SortedStream<A>(this, comparator);
    }

    @Override
    public final <B extends Comparable<B>> Stream<A> sortOn(Applicable<? super A, B> function) {
        return this.sortBy(Compare.on(function));
    }

    private Comparator<A> natural() {
        return Compare.natural();
    }

    @Override
    public Stream<A> reverse() {
        if (this.isEmpty()) {
            return Streams.empty();
        }
        LinkedList reversedList = new LinkedList();
        for (Object element : this) {
            reversedList.addFirst(element);
        }
        return Streams.from(reversedList);
    }

    @Override
    public <K> Map<K, A> groupOn(Applicable<? super A, K> groupFunction, Applicable2<? super A, ? super A, A> reduceFunction) {
        return this.groupOn(groupFunction, (Applicable)Functions.identity(), reduceFunction);
    }

    @Override
    public <K, V> Map<K, V> groupOn(Applicable<? super A, K> groupFunction, Applicable<? super A, V> mapFunction, Applicable2<? super V, ? super V, V> reduceFunction) {
        return this.mapReduce(groupFunction, Reductions.from(mapFunction, reduceFunction));
    }

    private <K, V> Map<K, V> mapReduce(Applicable<? super A, K> groupFunction, Reduction<A, V> reducer) {
        LinkedHashMap<Object, V> map = new LinkedHashMap<Object, V>();
        for (Object element : this) {
            Object key = groupFunction.apply(element);
            Object acum = map.get(key);
            if (acum != null) {
                map.put(key, reducer.reduce(element, acum));
                continue;
            }
            if (map.containsKey(key)) {
                map.put(key, reducer.reduce(element, null));
                continue;
            }
            map.put(key, reducer.initial(element));
        }
        return map;
    }

    @Override
    public Stream<Pair<A, A>> cross() {
        return this.cross(this);
    }

    @Override
    public <B> Stream<Pair<A, B>> cross(@NonNull Iterable<B> other) {
        return this.cross(Streams.from(other));
    }

    @Override
    @ForceRestrictions
    public <B> Stream<Pair<A, B>> cross(final @NonNull Stream<B> other) {
        Ensure.isNotNull((String)"var0", other);
        return this.transform((Applicable<Stream<A>, ? extends Stream<B>>)new AbstractFunction<Stream<A>, Stream<Pair<A, B>>>(){

            public Stream<Pair<A, B>> apply(Stream<A> stram) {
                return AbstractStream.this.flatMap(new AbstractFunction<A, Stream<Pair<A, B>>>(this, other){
                    final /* synthetic */ 5 this$1;
                    private final /* synthetic */ Stream val$other;
                    {
                        this.this$1 = var1_1;
                        this.val$other = stream;
                    }

                    public Stream<Pair<A, B>> apply(A x) {
                        return this.val$other.flatMap((Function)new AbstractFunction<B, Stream<Pair<A, B>>>(this, x){
                            final /* synthetic */ 6 this$2;
                            private final /* synthetic */ Object val$x;
                            {
                                this.this$2 = var1_1;
                                this.val$x = object;
                            }

                            public Stream<Pair<A, B>> apply(B y) {
                                return Streams.cons(Tuples._((Object)this.val$x, y));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    @ForceRestrictions
    public Stream<Stream<A>> crossStreams(@NonNull Stream<Stream<A>> other) {
        Ensure.isNotNull((String)"var0", other);
        Ensure.that().isNotEmpty("other", other);
        return AbstractStream.fcross(other.prepend(this));
    }

    private static <A> Stream<Stream<A>> fcross(Stream<Stream<A>> other) {
        return other.transform((Applicable)new AbstractFunction<Stream<Stream<A>>, Stream<Stream<A>>>(){

            public Stream<Stream<A>> apply(Stream<Stream<A>> xss_) {
                Stream xss = xss_.memorize();
                if (xss.size() == 2) {
                    return ((Stream)xss.first()).flatMap((Function)new AbstractFunction<A, Stream<Stream<A>>>(this, xss){
                        final /* synthetic */ 8 this$1;
                        private final /* synthetic */ Stream val$xss;
                        {
                            this.this$1 = var1_1;
                            this.val$xss = stream;
                        }

                        public Stream<Stream<A>> apply(A x) {
                            return ((Stream)this.val$xss.second()).flatMap((Function)new AbstractFunction<A, Stream<Stream<A>>>(this, x){
                                final /* synthetic */ 9 this$2;
                                private final /* synthetic */ Object val$x;
                                {
                                    this.this$2 = var1_1;
                                    this.val$x = object;
                                }

                                public Stream<Stream<A>> apply(A y) {
                                    return Streams.cons(Streams.cons(new Object[]{this.val$x, y}));
                                }
                            });
                        }
                    });
                }
                return ((Stream)xss.head()).flatMap((Function)new AbstractFunction<A, Stream<Stream<A>>>(this, xss){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ Stream val$xss;
                    {
                        this.this$1 = var1_1;
                        this.val$xss = stream;
                    }

                    public Stream<Stream<A>> apply(A x) {
                        return AbstractStream.access$0(this.val$xss.tail()).flatMap((Function)new AbstractFunction<Stream<A>, Stream<Stream<A>>>(this, x){
                            final /* synthetic */ 11 this$2;
                            private final /* synthetic */ Object val$x;
                            {
                                this.this$2 = var1_1;
                                this.val$x = object;
                            }

                            public Stream<Stream<A>> apply(Stream<A> ys) {
                                return Streams.cons(Streams.cons(this.val$x, ys));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public final void print(Appendable o) throws IOException {
        o.append('[');
        Pair<A, Stream<A>> ht = this.decons();
        this.printElement(o, ht._0());
        for (Object element : (Stream)ht._1()) {
            o.append(", ");
            this.printElement(o, element);
        }
        o.append(']');
    }

    private void printElement(Appendable o, A element) throws IOException {
        if (element instanceof Stream) {
            ((Stream)element).print(o);
        } else {
            o.append(String.valueOf(element));
        }
    }

    @Override
    public final void print() {
        try {
            this.println(System.out);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public final void println(Appendable o) throws IOException {
        this.print(o);
        o.append('\n');
    }

    @Override
    public final void println() {
        try {
            this.println(System.out);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public final String printString() {
        try {
            StringBuilder sb = new StringBuilder();
            this.print(sb);
            return sb.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Constant
    private static <A> Function<A[], Iterable<A>> toIterable() {
        return TO_ITERABLE;
    }

    public final String toString() {
        return ToString.toString((Object)this);
    }

    static /* synthetic */ Stream access$0(Stream stream) {
        return AbstractStream.fcross(stream);
    }

    private static Predicate2 equalOrEquivInitializer() {
        return Equiv.equalNullSafe().or((Evaluable2)new AbstractPredicate2<A, A>(){

            public boolean eval(A arg0, A arg1) {
                return arg0 instanceof Stream && arg1 instanceof Stream && ((Stream)arg0).equiv((Stream)arg1);
            }
        });
    }

    private static Function toIterableInitializer() {
        return new AbstractFunction<A[], Iterable<A>>(){

            public Iterable<A> apply(A[] arg) {
                return Arrays.asList(arg);
            }
        };
    }
}

