/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.impl;

import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.collections.stream.impl.StrictStream;
import net.sf.staccatocommons.iterators.CharSequenceThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotNegative;

public final class CharSequenceStream
extends StrictStream<Character> {
    private final CharSequence charSequence;

    public CharSequenceStream(@NonNull CharSequence charSequence) {
        Ensure.isNotNull((String)"var0", (Object)charSequence);
        this.charSequence = charSequence;
    }

    @Override
    public Thriterator<Character> iterator() {
        return new CharSequenceThriterator(this.charSequence);
    }

    @Override
    public int size() {
        return this.charSequence.length();
    }

    @Override
    public Character get(int n) {
        return Character.valueOf(this.charSequence.charAt(n));
    }

    @Override
    public Stream<Character> take(int amountOfElements) {
        return new CharSequenceStream(this.charSequence.subSequence(0, this.atMost(amountOfElements)));
    }

    @Override
    public Stream<Character> drop(@NotNegative int amountOfElements) {
        Ensure.that().isNotNegative("var0", amountOfElements);
        return new CharSequenceStream(this.charSequence.subSequence(this.atMost(amountOfElements), this.size()));
    }
}

