/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.collections.stream.impl.internal;

import java.util.NoSuchElementException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.collections.stream.AbstractStream;
import net.sf.staccatocommons.collections.stream.Stream;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.thriter.AdvanceThriterator;
import net.sf.staccatocommons.iterators.thriter.Thriter;
import net.sf.staccatocommons.iterators.thriter.Thriterator;
import net.sf.staccatocommons.iterators.thriter.Thriterators;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class AppendIterableStream<A>
extends AbstractStream<A> {
    private final Stream<A> stream;
    private final Iterable<A> other;

    public AppendIterableStream(@NonNull Stream<A> stream, @NonNull Iterable<A> other) {
        Ensure.isNotNull((String)"var1", other);
        Ensure.isNotNull((String)"var0", stream);
        this.stream = stream;
        this.other = other;
    }

    @Override
    public Thriterator<A> iterator() {
        return new AdvanceThriterator<A>(){
            private Thriter<A> iter;
            private boolean second;
            {
                this.iter = (Thriter)AppendIterableStream.this.stream.iterator();
                this.second = false;
            }

            public boolean hasNext() {
                if (this.iter.hasNext()) {
                    return true;
                }
                if (this.second) {
                    return false;
                }
                this.iter = (Thriter)Thriterators.from(AppendIterableStream.this.other.iterator());
                this.second = true;
                return this.iter.hasNext();
            }

            public void advanceNext() throws NoSuchElementException {
                this.iter.advanceNext();
            }

            public A current() throws NoSuchElementException {
                return this.iter.current();
            }

            public Thunk<A> delayedCurrent() {
                return this.iter.delayedCurrent();
            }
        };
    }
}

