/*
 * Decompiled with CFR 0.152.
 */
package ar.com.zauber.commons.mom.converter;

import ar.com.zauber.commons.mom.converter.TypeConverter;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;

public final class IdentityTypeConverter
implements TypeConverter {
    private static final TypeConverter CONVERTER = IdentityTypeConverter.converterInitializer();

    @Override
    @ForceRestrictions
    public boolean canConvert(@NonNull Class<?> sourceType, @NonNull Class<?> destinationType) {
        Ensure.isNotNull((String)"var1", destinationType);
        Ensure.isNotNull((String)"var0", sourceType);
        return destinationType.isAssignableFrom(sourceType);
    }

    @Override
    public <A> A convert(Object value, Class<A> destinationType) {
        Ensure.that((value == null || this.canConvert(value.getClass(), destinationType) ? 1 : 0) != 0, (String)"%s is not of type %s", (Object[])new Object[]{value, destinationType});
        return (A)value;
    }

    @Constant
    public static TypeConverter converter() {
        return CONVERTER;
    }

    private static TypeConverter converterInitializer() {
        return new IdentityTypeConverter();
    }
}

