/*
 * Decompiled with CFR 0.152.
 */
package ar.com.zauber.commons.mom.internal;

import ar.com.zauber.commons.mom.AbstractMapObjectMapper;
import ar.com.zauber.commons.mom.PropertyModel;
import ar.com.zauber.commons.mom.converter.TypeConverter;
import ar.com.zauber.commons.mom.internal.AttributesMap;
import ar.com.zauber.commons.mom.internal.MappingPackage;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;

public class DefaultMapObjectMapper
extends AbstractMapObjectMapper {
    private final MappingPackage mappingPackage;
    private final TypeConverter typeConverter;
    private final PropertyModel propertyModel;

    public DefaultMapObjectMapper(@NonNull String packageName, @NonNull PropertyModel propertyModel, @NonNull TypeConverter typeConverter) {
        Ensure.isNotNull((String)"var2", (Object)typeConverter);
        Ensure.isNotNull((String)"var1", (Object)propertyModel);
        Ensure.isNotNull((String)"var0", (Object)packageName);
        this.mappingPackage = new MappingPackage(packageName);
        this.typeConverter = typeConverter;
        this.propertyModel = propertyModel;
    }

    @Override
    @ForceRestrictions
    public boolean isCompositeType(@NonNull Class<?> clazz) {
        Ensure.isNotNull((String)"var0", clazz);
        return this.mappingPackage.isInMappeablePackage(clazz);
    }

    @Override
    protected Map<String, Object> mapObjectImpl(Object value) {
        Ensure.that((boolean)this.isCompositeType(value.getClass()), (String)"%s must be a composite type", (Object[])new Object[]{value});
        return new AttributesMap(value, this);
    }

    @Override
    protected Object coerce(Object value, Class<?> type) {
        return this.typeConverter.convert(value, type);
    }

    @Override
    protected <A> A unmapMapImpl(Map<String, Object> map, Class<A> targetType) {
        try {
            A bean = targetType.newInstance();
            this.unmapProperties(map, bean);
            return bean;
        }
        catch (Exception e) {
            throw SoftException.soften((Exception)e);
        }
    }

    protected void unmapProperties(@NonNull Map<String, Object> source, @NonNull Object destination) throws IllegalAccessException, InvocationTargetException {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            if (entry.getKey().equals("__javaType")) continue;
            this.propertyModel.setProperty(entry.getValue(), destination, entry.getKey(), this);
        }
    }
}

