/*
 * Decompiled with CFR 0.152.
 */
package ar.com.zauber.commons.mom.internal;

import ar.com.zauber.commons.mom.MapObjectMapper;
import ar.com.zauber.commons.mom.MapObjectMapperBuilder;
import ar.com.zauber.commons.mom.MapObjectMapperInterceptor;
import ar.com.zauber.commons.mom.PropertyModel;
import ar.com.zauber.commons.mom.converter.CompositeTypeConverter;
import ar.com.zauber.commons.mom.converter.IdentityTypeConverter;
import ar.com.zauber.commons.mom.converter.TypeConverter;
import ar.com.zauber.commons.mom.internal.DefaultMapObjectMapper;
import ar.com.zauber.commons.mom.internal.InterceptingMapObjectMapper;
import ar.com.zauber.commons.mom.internal.SimplePropertyModel;
import ar.com.zauber.commons.mom.style.NamingStyle;
import ar.com.zauber.commons.mom.style.SetterStyle;
import ar.com.zauber.commons.mom.style.impl.BeanNamingStyle;
import ar.com.zauber.commons.mom.style.impl.BeanStyle;
import java.util.LinkedList;
import java.util.List;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.lang.Nulls;
import net.sf.staccatocommons.restrictions.check.NonNull;
import net.sf.staccatocommons.restrictions.check.NotEmpty;
import net.sf.staccatocommons.restrictions.processing.ForceRestrictions;

public class DefaultMapObjectMapperBuilder
implements MapObjectMapperBuilder {
    private final String packageName;
    private SetterStyle setterStyle;
    private NamingStyle namingStyle;
    private PropertyModel propertyModel;
    private List<TypeConverter> converters;
    private MapObjectMapperInterceptor interceptor;

    public DefaultMapObjectMapperBuilder(@NotEmpty String packageName) {
        Ensure.that().isNotEmpty("var0", (CharSequence)packageName);
        this.converters = new LinkedList<TypeConverter>();
        this.interceptor = null;
        this.packageName = packageName;
        this.withConverter(IdentityTypeConverter.converter());
    }

    @Override
    @ForceRestrictions
    public final MapObjectMapperBuilder withSetterStyle(@NonNull SetterStyle style) {
        Ensure.isNotNull((String)"var0", (Object)style);
        this.setterStyle = style;
        return this;
    }

    @Override
    @ForceRestrictions
    public final MapObjectMapperBuilder withConverter(@NonNull TypeConverter converter) {
        Ensure.isNotNull((String)"var0", (Object)converter);
        this.converters.add(converter);
        return this;
    }

    @Override
    @ForceRestrictions
    public final MapObjectMapperBuilder withInterceptor(@NonNull MapObjectMapperInterceptor inter) {
        Ensure.isNotNull((String)"var0", (Object)inter);
        this.interceptor = inter;
        return this;
    }

    @Override
    @ForceRestrictions
    public final MapObjectMapperBuilder withNamingStyle(@NonNull NamingStyle style) {
        Ensure.isNotNull((String)"var0", (Object)style);
        this.namingStyle = style;
        return this;
    }

    @Override
    @ForceRestrictions
    public final MapObjectMapperBuilder withPropertyModel(@NonNull PropertyModel model) {
        Ensure.isNotNull((String)"var0", (Object)model);
        this.propertyModel = model;
        return this;
    }

    @Override
    public MapObjectMapper build() {
        if (this.interceptor == null) {
            return new DefaultMapObjectMapper(this.packageName, this.buildPropertyModel(), this.buildTypeConverter());
        }
        return new InterceptingMapObjectMapper(this.packageName, this.buildPropertyModel(), this.buildTypeConverter(), this.interceptor);
    }

    private PropertyModel buildPropertyModel() {
        if (this.propertyModel != null) {
            Ensure.that((this.setterStyle == null ? 1 : 0) != 0, (String)"Either set the property model or the setter style, but not both", (Object[])new Object[0]);
            Ensure.that((this.namingStyle == null ? 1 : 0) != 0, (String)"Either set the property model or the naming style, but not both", (Object[])new Object[0]);
            return this.propertyModel;
        }
        return new SimplePropertyModel(this.buildSetterStyle(), this.buildNamingStyle());
    }

    private NamingStyle buildNamingStyle() {
        return (NamingStyle)Nulls.coalesce((Object)this.namingStyle, (Object)BeanNamingStyle.syle());
    }

    private SetterStyle buildSetterStyle() {
        return (SetterStyle)Nulls.coalesce((Object)this.setterStyle, (Object)BeanStyle.STYLE);
    }

    private CompositeTypeConverter buildTypeConverter() {
        return new CompositeTypeConverter(this.converters);
    }
}

