/*
 * Decompiled with CFR 0.152.
 */
package ar.com.zauber.commons.mom.internal;

import ar.com.zauber.commons.mom.MapObjectMapper;
import ar.com.zauber.commons.mom.PropertyModel;
import ar.com.zauber.commons.mom.StructureType;
import ar.com.zauber.commons.mom.style.NamingStyle;
import ar.com.zauber.commons.mom.style.SetterStyle;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.lang.SoftException;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class SimplePropertyModel
implements PropertyModel {
    private final SetterStyle setterStyle;
    private final NamingStyle namingStyle;

    public SimplePropertyModel(@NonNull SetterStyle setterStyle, @NonNull NamingStyle namingStyle) {
        Ensure.isNotNull((String)"var1", (Object)namingStyle);
        Ensure.isNotNull((String)"var0", (Object)setterStyle);
        this.setterStyle = setterStyle;
        this.namingStyle = namingStyle;
    }

    @Override
    public void setProperty(Object propertyValue, Object destination, String mapKey, MapObjectMapper mom) {
        String propertyName = this.namingStyle.getPropertyName(mapKey);
        Class<?> targetType = StructureType.getStructureType(destination, propertyName);
        try {
            this.setterStyle.setValue(destination, propertyName, mom.unmap(propertyValue, targetType));
        }
        catch (Exception e) {
            throw SoftException.soften((Exception)e);
        }
    }
}

