/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang;

import java.io.Serializable;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.ContainsAware;
import net.sf.staccatocommons.defs.EmptyAware;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.lang.Compare;
import net.sf.staccatocommons.lang.sequence.Sequence;
import net.sf.staccatocommons.lang.sequence.StopConditions;
import net.sf.staccatocommons.lang.value.RelevantState;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Range<T extends Comparable<T>>
implements ContainsAware<T>,
EmptyAware,
Serializable {
    private static final long serialVersionUID = -1096861117755452369L;
    private static final RelevantState<Range> STATE = new RelevantState<Range>(2){

        @Override
        protected void collectState(Range object, RelevantState.StateCollector s) {
            s.add(object.min).add(object.max);
        }
    };
    private final T min;
    private final T max;

    public Range(@NonNull T min, @NonNull T max) {
        Ensure.isNotNull((String)"var1", max);
        Ensure.isNotNull((String)"var0", min);
        Ensure.that().isGreaterThanOrEqualTo("max", max, min);
        this.min = min;
        this.max = max;
    }

    public boolean contains(@NonNull T element) {
        return Compare.between(element, this.min, this.max);
    }

    public boolean overlaps(@NonNull Range<T> that) {
        return this.contains(that.getMin()) || this.contains(that.getMin()) || that.contains(this.getMin());
    }

    public boolean includes(@NonNull Range<T> that) {
        return this.getMin().compareTo(that.getMin()) <= 0 && this.getMax().compareTo(that.getMax()) >= 0;
    }

    @NonNull
    public T getMax() {
        return this.max;
    }

    @NonNull
    public T getMin() {
        return this.min;
    }

    public boolean isEmpty() {
        return this.getMin().compareTo(this.getMax()) == 0;
    }

    public boolean equals(Object obj) {
        return STATE.equals(this, obj);
    }

    public int hashCode() {
        return STATE.hashCode(this);
    }

    public String toString() {
        return STATE.toString(this);
    }

    @NonNull
    public Sequence<T> by(@NonNull Applicable<T, T> generator) {
        return Sequence.from(this.getMin(), generator, (Evaluable)StopConditions.upTo(this.getMax()));
    }

    @NonNull
    public static <T extends Comparable<T>> Range<T> from(@NonNull T min, @NonNull T max) {
        return new Range<T>(min, max);
    }
}

