/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang;

import java.util.Iterator;
import net.sf.staccatocommons.defs.Executable;
import net.sf.staccatocommons.defs.Thunk;
import net.sf.staccatocommons.iterators.thriter.Thriterators;
import net.sf.staccatocommons.lang.Option;
import net.sf.staccatocommons.lang.internal.ToString;
import net.sf.staccatocommons.lang.value.BasicEquals;
import net.sf.staccatocommons.restrictions.check.NonNull;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class Some<T>
extends Option<T> {
    private static final long serialVersionUID = 5981912873938772033L;
    private static final Some<?> SOME_NULL = new Some<Object>(null);
    private final T value;

    public Some(T value) {
        this.value = value;
    }

    @Override
    public T value() {
        return this.value;
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public T valueOrElse(T ifUndefined) {
        return this.value;
    }

    @Override
    public T valueOrElse(Thunk<? extends T> ifUndefined) {
        return this.value;
    }

    @Override
    public T valueOrNull() {
        return this.value;
    }

    @Override
    public void ifDefined(@NonNull Executable<T> block) {
        block.exec(this.value);
    }

    @Override
    public Iterator<T> iterator() {
        return (Iterator)Thriterators.from(this.value);
    }

    public boolean contains(T element) {
        return ObjectUtils.equals(this.value, element);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.value).toHashCode();
    }

    public boolean equals(Object obj) {
        BasicEquals be = BasicEquals.from(this, obj);
        if (be.isEqualsDone()) {
            return be.toEquals();
        }
        Some that = (Some)obj;
        return new EqualsBuilder().append(this.value, that.value).isEquals();
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return ToString.toString(this);
    }

    public static <T> Some<T> some(T value) {
        if (value != null) {
            return new Some<T>(value);
        }
        return Some.someNull();
    }

    public static <T> Some<T> someNull() {
        return SOME_NULL;
    }
}

