/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.number;

import java.math.BigDecimal;
import java.math.BigInteger;
import net.sf.staccatocommons.defs.function.Function;
import net.sf.staccatocommons.defs.type.NumberType;
import net.sf.staccatocommons.lang.number.internal.BigDecimalType;
import net.sf.staccatocommons.lang.number.internal.BigIntegerType;
import net.sf.staccatocommons.lang.number.internal.DoubleType;
import net.sf.staccatocommons.lang.number.internal.FloatType;
import net.sf.staccatocommons.lang.number.internal.IntegerType;
import net.sf.staccatocommons.lang.number.internal.LongType;
import net.sf.staccatocommons.restrictions.Constant;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class NumberTypes {
    private NumberTypes() {
    }

    @Constant
    public static NumberType<BigDecimal> bigDecimal() {
        return BigDecimalType.TYPE;
    }

    @Constant
    public static NumberType<BigInteger> bigInteger() {
        return BigIntegerType.TYPE;
    }

    @Constant
    public static NumberType<Double> double_() {
        return DoubleType.TYPE;
    }

    @Constant
    public static NumberType<Float> float_() {
        return FloatType.TYPE;
    }

    @Constant
    public static NumberType<Integer> integer() {
        return IntegerType.TYPE;
    }

    @Constant
    public static NumberType<Long> long_() {
        return LongType.TYPE;
    }

    @NonNull
    public static Function<BigInteger, BigInteger> add(@NonNull BigInteger n) {
        return BigIntegerType.TYPE.add(n);
    }

    @NonNull
    public static Function<BigDecimal, BigDecimal> add(@NonNull BigDecimal n) {
        return BigDecimalType.TYPE.add(n);
    }

    @NonNull
    public static Function<Integer, Integer> add(@NonNull Integer n) {
        return IntegerType.TYPE.add(n);
    }
}

