/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.sequence;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.staccatocommons.check.Ensure;
import net.sf.staccatocommons.defs.Applicable;
import net.sf.staccatocommons.defs.Evaluable;
import net.sf.staccatocommons.iterators.AbstractUnmodifiableIterator;
import net.sf.staccatocommons.lang.internal.ToString;
import net.sf.staccatocommons.lang.number.NumberTypes;
import net.sf.staccatocommons.lang.sequence.StopConditions;
import net.sf.staccatocommons.restrictions.check.NonNull;

public class Sequence<A>
implements Iterable<A>,
Serializable {
    private static final long serialVersionUID = 8811454338704704525L;
    private final A seed;
    private final Applicable<? super A, ? extends A> generator;
    private final Evaluable<? super A> stopCondition;

    public Sequence(A seed, @NonNull Applicable<? super A, ? extends A> generator, @NonNull Evaluable<? super A> stopCondition) {
        Ensure.isNotNull((String)"var2", stopCondition);
        Ensure.isNotNull((String)"var1", generator);
        this.seed = seed;
        this.generator = generator;
        this.stopCondition = stopCondition;
    }

    public A getSeed() {
        return this.seed;
    }

    @NonNull
    public Applicable<A, A> getGenerator() {
        return this.generator;
    }

    @NonNull
    public Evaluable<A> getStopCondition() {
        return this.stopCondition;
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public Iterator<A> iterator() {
        return new AbstractUnmodifiableIterator<A>(){
            private A next;
            {
                this.next = Sequence.this.getSeed();
            }

            public boolean hasNext() {
                return !this.stop();
            }

            private boolean stop() {
                return Sequence.this.getStopCondition().eval(this.next);
            }

            public A next() {
                if (this.stop()) {
                    throw new NoSuchElementException();
                }
                Object next = this.next;
                this.next = Sequence.this.getGenerator().apply(next);
                return next;
            }
        };
    }

    @NonNull
    public static <A> Sequence<A> from(A seed, @NonNull Applicable<? super A, ? extends A> generator, @NonNull Evaluable<? super A> stopCondition) {
        return new Sequence<A>(seed, generator, stopCondition);
    }

    @NonNull
    public static Sequence<Integer> fromBy(int from, int step) {
        return new Sequence<Integer>(from, (Applicable<Integer, Integer>)NumberTypes.add(step), (Evaluable<Integer>)((Evaluable)StopConditions.stopNever()));
    }

    @NonNull
    public static Sequence<Integer> fromToBy(int from, int to, int step) {
        Ensure.that((String)"step", (Object)step, (step != 0 ? 1 : 0) != 0, (String)"must be non zero", (Object[])new Object[0]);
        return new Sequence<Integer>(from, (Applicable<Integer, Integer>)NumberTypes.add(step), (Evaluable<Integer>)(step < 0 ? StopConditions.downTo(to) : StopConditions.upTo(to)));
    }

    @NonNull
    public static Sequence<Integer> fromTo(int from, int to) {
        return Sequence.fromToBy(from, to, from < to ? 1 : -1);
    }
}

