/*
 * Decompiled with CFR 0.152.
 */
package net.sf.staccatocommons.lang.tuple;

import java.util.Map;
import net.sf.staccatocommons.lang.tuple.Tuple;
import net.sf.staccatocommons.lang.value.RelevantState;
import net.sf.staccatocommons.restrictions.check.NonNull;

public final class Pair<T1, T2>
extends Tuple
implements Comparable<Pair<T1, T2>>,
Map.Entry<T1, T2>,
Tuple.FirstAware<T1>,
Tuple.SecondAware<T2> {
    private static final long serialVersionUID = -6479045670420592337L;
    private static final RelevantState<Pair> VAL = new Tuple.TupleState<Pair>(2){

        @Override
        protected void collectState(Pair o, RelevantState.StateCollector s) {
            s.add(o.first).add(o.second);
        }
    };
    private final T1 first;
    private final T2 second;

    public Pair(T1 fist, T2 second) {
        this.first = fist;
        this.second = second;
    }

    @Override
    public T1 first() {
        return this.first;
    }

    @Override
    public T1 _0() {
        return this.first;
    }

    @Override
    public T2 second() {
        return this.second;
    }

    @Override
    public T2 _1() {
        return this.second;
    }

    @NonNull
    public Pair<T2, T1> swap() {
        return new Pair<T2, T1>(this.second, this.first);
    }

    public String toString() {
        return VAL.toString(this);
    }

    @Override
    @NonNull
    public Object[] toArray() {
        return new Object[]{this.first, this.second};
    }

    @Override
    public int compareTo(Pair<T1, T2> other) {
        return VAL.compareTo(this, other);
    }

    @Override
    public int hashCode() {
        return VAL.hashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return VAL.equals(this, obj);
    }

    @Override
    public T1 getKey() {
        return this.first();
    }

    @Override
    public T2 getValue() {
        return this.second();
    }

    @Override
    public T2 setValue(T2 arg0) {
        throw new UnsupportedOperationException();
    }
}

