/**
 * Mule Zuora Cloud Connector
 *
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

/**
 * This file was automatically generated by the Mule Development Kit
 */
package org.mule.modules.zuora;

import java.util.List;
import java.util.Map;

import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.InvalidateConnectionOn;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.modules.zuora.zobject.ZObjectType;
import org.mule.modules.zuora.zuora.api.CxfZuoraClient;
import org.mule.modules.zuora.zuora.api.SessionTimedOutException;
import org.mule.modules.zuora.zuora.api.ZObjectMapper;
import org.mule.modules.zuora.zuora.api.ZuoraClient;

import com.zuora.api.AmendResult;
import com.zuora.api.DeleteResult;
import com.zuora.api.ErrorCode;
import com.zuora.api.LoginFault;
import com.zuora.api.SaveResult;
import com.zuora.api.SubscribeResult;
import com.zuora.api.UnexpectedErrorFault;
import com.zuora.api.object.ZObject;

/**
 * Zuora is the leader in online recurring billing and payment solutions for SaaS and subscription businesses.
 * <p/>
 * This connector provides full access to the Z-Commerce platform API.
 *
 * @author MuleSoft, Inc.
 */
@Connector(name = "zuora")
public class ZuoraModule {

    /**
     * The client to use. Mainly for mocking purposes
     */
    @Configurable
    @Optional
    private ZuoraClient<Exception> client;

    /**
     * Target URI to connect to
     */
    @Configurable
    @Default("htps://apisandbox.zuora.com/apps/services/a/32.0")
    @Optional
    private String endpoint;


    /**
     * Connects to Zuora
     *
     * @param username Username to identify the user
     * @param password Password to authenticate the username
     */
    @Connect
    public synchronized void connect(@ConnectionKey String username, String password)
            throws ConnectionException {
        try {
            client = new CxfZuoraClient(username, password, this.endpoint);
        } catch (UnexpectedErrorFault e) {
            throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, e.getFaultInfo().getFaultCode().value(), e.getFaultInfo().getFaultMessage());
        } catch (LoginFault e) {
            if (e.getFaultInfo().getFaultCode() == ErrorCode.INVALID_LOGIN) {
                throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, e.getFaultInfo().getFaultCode().value(), e.getFaultInfo().getFaultMessage());
            } else {
                throw new ConnectionException(ConnectionExceptionCode.UNKNOWN, e.getFaultInfo().getFaultCode().value(), e.getFaultInfo().getFaultMessage());
            }
        }
    }

    @ValidateConnection
    public boolean isConnected() {
        return client != null;
    }

    /**
     * Destroys the session
     */
    @Disconnect
    public synchronized void disconnect() {
        client = null;
    }

    @ConnectionIdentifier
    public String getSessionId() {
        return client.getSessionId();
    }

    /**
     * Batch creation of ZObjects associated to Subscriptions
     * <p/>
     * {@sample.xml ../../../doc/mule-module-zuora.xml.sample zuora:subscribe}
     *
     * @param subscriptions the list of subscriptions to perform
     * @return a subscription results list, one for each subscription
     */
    @Processor
    @InvalidateConnectionOn(exception=SessionTimedOutException.class)
    public List<SubscribeResult> subscribe(List<com.zuora.api.SubscribeRequest> subscriptions)
            throws Exception {
        return client.subscribe(subscriptions);
    }

    /**
     * Batch creation of ZObjects
     * <p/>
     * {@sample.xml ../../../doc/mule-module-zuora.xml.sample zuora:create}
     *
     * @param zobjects the zobjects to create
     * @param type     the type of zobject passed
     * @return a list of {@link SaveResult}, one for each ZObject
     */
    @Processor
    @InvalidateConnectionOn(exception=SessionTimedOutException.class)
    public List<SaveResult> create(ZObjectType type, List<Map<String, Object>> zobjects)
            throws Exception {
        return client.create(ZObjectMapper.toZObject(type, zobjects));
    }

    /**
     * Batch creation of invoces for accounts
     * <p/>
     * {@sample.xml ../../../doc/mule-module-zuora.xml.sample zuora:generate}
     *
     * @param zobjects the zobjects to generate, as a list of string-object maps .
     *                 Zuora attribute names, unlike java beans, are CamelCase.
     * @param type     the type of zobject passed
     * @return a list of {@link SaveResult}, one for each ZObject
     */
    @Processor
    @InvalidateConnectionOn(exception=SessionTimedOutException.class)
    public List<SaveResult> generate(ZObjectType type, List<Map<String, Object>> zobjects)
            throws Exception {
        return client.generate(ZObjectMapper.toZObject(type, zobjects));
    }

    /**
     * Batch update of ZObjects
     * <p/>
     * {@sample.xml ../../../doc/mule-module-zuora.xml.sample zuora:update}
     *
     * @param zobjects the zobjects to update, as a list of string-object maps .
     *                 Zuora attribute names, unlike java beans, are CamelCase.
     * @param type     the type of zobject passed
     * @return a list of {@link SaveResult}, one for each ZObject
     */
    @Processor
    @InvalidateConnectionOn(exception=SessionTimedOutException.class)
    public List<SaveResult> update(ZObjectType type, List<Map<String, Object>> zobjects)
            throws Exception {
        return client.update(ZObjectMapper.toZObject(type, zobjects));
    }

    /**
     * Batch delete of ZObjects
     * <p/>
     * {@sample.xml ../../../doc/mule-module-zuora.xml.sample zuora:delete}
     *
     * @param type the type of ZObjects to delete
     * @param ids  the list of ids to delete
     * @return a list of {@link DeleteResult}, one for each id
     */
    @Processor
    @InvalidateConnectionOn(exception=SessionTimedOutException.class)
    public List<DeleteResult> delete(ZObjectType type, List<String> ids)
            throws Exception {
        return client.delete(type.getTypeName(), ids);
    }

    /**
     * Lazily retrieves ZObject that match a given query,
     * written in Zuora native query language
     * <p/>
     * {@sample.xml ../../../doc/mule-module-zuora.xml.sample zuora:find}
     *
     * @param zquery the query, using the SQL-Like Zuora Query Language
     * @return a {@link ZObject} iterable. {@link ZObject} returned by this operation
     *         may be instances of either static ZObject - like Account or Amendment -,  if the object is a non-customizable Zuora entity,
     *         or {@link ZObject},  if the object is a customizable Zuora entity
     */
    @Processor
    @InvalidateConnectionOn(exception=SessionTimedOutException.class)
    public Iterable<ZObject> find(String zquery)
            throws Exception {
        return client.find(zquery);
    }

    /**
     * Retrieve a product profile
     * <p/>
     * {@sample.xml ../../../doc/mule-module-zuora.xml.sample zuora:product-profile}
     *
     * @param productId The id of the product to retrieve a product profile for
     * @return the profile, as a String-Object Map
     * @throws {@link ZuoraException}
     */
    @Processor
    @InvalidateConnectionOn(exception=SessionTimedOutException.class)
    public Map<String, Object> productProfile(String productId) throws Exception {
        return client.productProfile(productId);
    }

    /**
     * Answers user information
     * <p/>
     * {@sample.xml ../../../doc/mule-module-zuora.xml.sample zuora:get-user-info}
     *
     * @return a {@link User}
     */
    @Processor
    @InvalidateConnectionOn(exception=SessionTimedOutException.class)
    public User getUserInfo()
            throws Exception {
        return client.getUserInfo();
    }

    /**
     * Amends subscriptions
     * <p/>
     * {@sample.xml ../../../doc/mule-module-zuora.xml.sample zuora:amend}
     *
     * @param amendaments the list of amendaments to perform
     * @return a list of {@link AmendResult}, one for each amendament
     */
    @Processor
    @InvalidateConnectionOn(exception=SessionTimedOutException.class)
    public List<AmendResult> amend(List<com.zuora.api.AmendRequest> amendaments)
            throws Exception {
        return client.amend(amendaments);
    }

    /**
     * Retrieve an account profile
     * <p/>
     * {@sample.xml ../../../doc/mule-module-zuora.xml.sample zuora:account-profile}
     * 
     * @param accountId The id of the account to retrieve an account profile for
     * @return the account, as a String-Object Map
     */
    @Processor
    @InvalidateConnectionOn(exception=SessionTimedOutException.class)
    public Map<String, Object> accountProfile(String accountId)
            throws Exception {
        return client.accountProfile(accountId);
    }
    
    public void setEndpoint(String enpoint) {
        this.endpoint = enpoint;
    }

    public String getEnpoint() {
        return endpoint;
    }

    public void setClient(ZuoraClient<Exception> client) {
        this.client = client;
    }
}
