
package org.mule.modules.zuora.config;

import org.mule.api.Capabilities;
import org.mule.api.Capability;
import org.mule.modules.zuora.ZuoraModule;


/**
 * A <code>ZuoraModuleCapabilitiesAdapter</code> is a wrapper around {@link ZuoraModule } that implements {@link org.mule.api.Capabilities} interface.
 * 
 */
public class ZuoraModuleCapabilitiesAdapter
    extends ZuoraModule
    implements Capabilities
{


    /**
     * Returns true if this module implements such capability
     * 
     */
    public boolean isCapableOf(Capability capability) {
        if (capability == Capability.LIFECYCLE_CAPABLE) {
            return true;
        }
        if (capability == Capability.CONNECTION_MANAGEMENT_CAPABLE) {
            return true;
        }
        return false;
    }

}
