/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.log4j.Logger;
import org.mule.api.callback.SourceCallback;
import org.mule.modules.slack.client.SlackClient;
import org.mule.modules.slack.client.exceptions.UserNotFoundException;
import org.mule.modules.slack.client.model.User;
import org.mule.modules.slack.client.model.channel.Channel;
import org.mule.modules.slack.client.model.chat.Message;
import org.mule.modules.slack.client.model.chat.MessageResponse;
import org.mule.modules.slack.client.model.chat.attachment.ChatAttachment;
import org.mule.modules.slack.client.model.chat.attachment.Field;
import org.mule.modules.slack.client.model.file.FileUploadResponse;
import org.mule.modules.slack.client.model.group.Group;
import org.mule.modules.slack.client.model.im.DirectMessageChannel;
import org.mule.modules.slack.client.model.im.DirectMessageChannelCreationResponse;
import org.mule.modules.slack.retrievers.ChannelMessageRetriever;
import org.mule.modules.slack.retrievers.DirectMessageRetriever;
import org.mule.modules.slack.retrievers.GroupMessageRetriever;
import org.mule.modules.slack.retrievers.MessageRetriever;
import org.mule.modules.slack.strategy.OAuth2ConnectionStrategy;
import org.mule.modules.slack.strategy.SlackConnectionStrategy;

public class SlackConnector {
    private static final Logger logger = Logger.getLogger(SlackConnector.class);
    SlackConnectionStrategy connectionStrategy;

    public User getUserInfo(String id) throws UserNotFoundException {
        return this.slack().getUserInfo(id);
    }

    public User getUserInfoByName(String username) throws UserNotFoundException {
        return this.slack().getUserInfoByName(username);
    }

    public List<User> getUserList() {
        return this.slack().getUserList();
    }

    public List<Channel> getChannelList() {
        return this.slack().getChannelList();
    }

    public List<Message> getChannelHistory(String channelId, String latestTimestamp, String oldestTimestamp, String mountOfMessages) {
        return this.slack().getChannelHistory(channelId, latestTimestamp, oldestTimestamp, mountOfMessages);
    }

    public Channel getChannelInfo(String channelId) {
        return this.slack().getChannelById(channelId);
    }

    public Channel getChannelByName(String channelName) {
        return this.slack().getChannelByName(channelName);
    }

    public Channel createChannel(String channelName) {
        return this.slack().createChannel(channelName);
    }

    public Channel renameChannel(String channelId, String channelName) {
        return this.slack().renameChannel(channelId, channelName);
    }

    public Channel joinChannel(String channelName) {
        return this.slack().joinChannel(channelName);
    }

    public Boolean leaveChannel(String channelId) {
        return this.slack().leaveChannel(channelId);
    }

    public Boolean archiveChannel(String channelID) {
        return this.slack().archiveChannel(channelID);
    }

    public Boolean unarchiveChannel(String channelID) {
        return this.slack().unarchiveChannel(channelID);
    }

    public Boolean setChannelTopic(String channelID, String topic) {
        return this.slack().setChannelTopic(channelID, topic);
    }

    public Boolean setChannelPurpose(String channelID, String purpose) {
        return this.slack().setChannelPurpose(channelID, purpose);
    }

    public MessageResponse postMessage(String message, String channelId, String username, String iconURL, Boolean asUser) {
        return this.slack().sendMessage(message, channelId, username, iconURL, BooleanUtils.toBoolean((Boolean)asUser));
    }

    public MessageResponse postMessageWithAttachment(String message, String channelId, String username, String iconURL, ChatAttachment chatAttachment, Field field, Boolean asUser) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(field);
        chatAttachment.setFields(fields);
        return this.slack().sendMessageWithAttachment(message, channelId, username, iconURL, chatAttachment, BooleanUtils.toBoolean((Boolean)asUser));
    }

    public Boolean deleteMessage(String timeStamp, String channelId) {
        return this.slack().deleteMessage(timeStamp, channelId);
    }

    public Boolean updateMessage(String timeStamp, String channelId, String message) {
        return this.slack().updateMessage(timeStamp, channelId, message);
    }

    public DirectMessageChannelCreationResponse openDirectMessageChannel(String userId) {
        return this.slack().openDirectMessageChannel(userId);
    }

    public Boolean closeDirectMessageChannel(String channelId) {
        return this.slack().closeDirectMessageChannel(channelId);
    }

    public List<DirectMessageChannel> listDirectMessageChannels() {
        return this.slack().getDirectMessageChannelsList();
    }

    public List<Message> getDMHistory(String channelID, String latestTimestamp, String oldestTimestamp, String mountOfMessages) {
        return this.slack().getDirectChannelHistory(channelID, latestTimestamp, oldestTimestamp, mountOfMessages);
    }

    public List<Group> getGroupList() {
        return this.slack().getGroupList();
    }

    public List<Message> getGroupHistory(String groupID, String latestTimestamp, String oldestTimestamp, String mountOfMessages) {
        return this.slack().getGroupHistory(groupID, latestTimestamp, oldestTimestamp, mountOfMessages);
    }

    public Boolean setGroupTopic(String channelID, String topic) {
        return this.slack().setGroupTopic(channelID, topic);
    }

    public Boolean setGroupPurpose(String channelID, String purpose) {
        return this.slack().setGroupPurpose(channelID, purpose);
    }

    public Group createGroup(String groupName) {
        return this.slack().createGroup(groupName);
    }

    public Boolean closeGroup(String channelID) {
        return this.slack().closeGroup(channelID);
    }

    public Boolean openGroup(String channelID) {
        return this.slack().openGroup(channelID);
    }

    public Boolean archiveGroup(String channelID) {
        return this.slack().archiveGroup(channelID);
    }

    public Boolean unarchiveGroup(String channelID) {
        return this.slack().unarchiveGroup(channelID);
    }

    public Group renameGroup(String groupId, String groupName) {
        return this.slack().renameGroup(groupId, groupName);
    }

    public Group getGroupInfo(String channelId) {
        return this.slack().getGroupInfo(channelId);
    }

    public Boolean leaveGroup(String channelId) {
        return this.slack().leaveGroup(channelId);
    }

    public FileUploadResponse uploadFile(String channelID, String fileName, String fileType, String title, String initialComment, String filePath) throws IOException {
        return this.slack().sendFile(channelID, fileName, fileType, title, initialComment, filePath);
    }

    public FileUploadResponse uploadFileAsInputStreams(String channelID, String fileName, String fileType, String title, String initialComment, InputStream inputStream) throws IOException {
        return this.slack().sendFile(channelID, fileName, fileType, title, initialComment, inputStream);
    }

    public Message retrieveMessages(SourceCallback source, Integer messageRetrieverInterval, String channelID) throws Exception {
        if (this.getConnectionStrategy().getClass().equals(OAuth2ConnectionStrategy.class)) {
            while (true) {
                logger.error((Object)"Retrieve Messages source doesn't work with OAuth 2 configuration, please use Connection Management");
                Thread.sleep(5000L);
            }
        }
        while (!this.getConnectionStrategy().isAuthorized().booleanValue()) {
            Thread.sleep(1000L);
            logger.debug((Object)"Waiting authorization!");
        }
        MessageRetriever messageRetriever = this.getMessageVerifierForChannel(channelID);
        String oldestTimeStamp = messageRetriever.retrieve(this.slack(), channelID, null, null, "1").get(0).getTs();
        block2: while (true) {
            Thread.sleep(messageRetrieverInterval.intValue());
            List<Message> messages = messageRetriever.retrieve(this.slack(), channelID, null, oldestTimeStamp, "1000");
            if (!messages.isEmpty()) {
                oldestTimeStamp = messages.get(0).getTs();
            }
            Integer i = messages.size();
            while (true) {
                if (i <= 0) continue block2;
                source.process((Object)messages.get(i - 1));
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i - 1);
            }
            break;
        }
    }

    private MessageRetriever getMessageVerifierForChannel(String channelID) throws Exception {
        if (channelID.toLowerCase().toLowerCase().startsWith("g")) {
            logger.info((Object)("Started retrieving messages of channel: " + this.slack().getGroupInfo(channelID).getName() + "!"));
            return new GroupMessageRetriever();
        }
        if (channelID.toLowerCase().toLowerCase().startsWith("c")) {
            logger.info((Object)("Started retrieving messages of channel: " + this.slack().getChannelById(channelID).getName() + "!"));
            return new ChannelMessageRetriever();
        }
        if (channelID.toLowerCase().toLowerCase().startsWith("d")) {
            logger.info((Object)"Started retrieving messages of direct message channel!");
            return new DirectMessageRetriever();
        }
        throw new Exception("Incorrect name for channel");
    }

    public SlackClient slack() {
        return this.connectionStrategy.getSlackClient();
    }

    public SlackConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public void setConnectionStrategy(SlackConnectionStrategy connectionStrategy) {
        this.connectionStrategy = connectionStrategy;
    }
}

