/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.shaded.internal;

import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.ws.rs.shaded.core.CacheControl;
import javax.ws.rs.shaded.core.Cookie;
import javax.ws.rs.shaded.core.EntityTag;
import javax.ws.rs.shaded.core.Link;
import javax.ws.rs.shaded.core.MediaType;
import javax.ws.rs.shaded.core.NewCookie;
import javax.ws.rs.shaded.core.Response;
import javax.ws.rs.shaded.core.UriBuilder;
import javax.ws.rs.shaded.core.Variant;
import javax.ws.rs.shaded.ext.RuntimeDelegate;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.shaded.internal.inject.Providers;
import org.glassfish.jersey.shaded.message.internal.JerseyLink;
import org.glassfish.jersey.shaded.message.internal.OutboundJaxrsResponse;
import org.glassfish.jersey.shaded.message.internal.OutboundMessageContext;
import org.glassfish.jersey.shaded.message.internal.VariantListBuilder;
import org.glassfish.jersey.shaded.spi.HeaderDelegateProvider;
import org.glassfish.jersey.shaded.uri.internal.JerseyUriBuilder;

public abstract class AbstractRuntimeDelegate
extends RuntimeDelegate {
    private final Set<HeaderDelegateProvider> hps;
    private final Map<Class<?>, RuntimeDelegate.HeaderDelegate<?>> map;

    protected AbstractRuntimeDelegate(ServiceLocator serviceLocator) {
        this.hps = Providers.getProviders(serviceLocator, HeaderDelegateProvider.class);
        this.map = new WeakHashMap();
        this.map.put(EntityTag.class, this._createHeaderDelegate(EntityTag.class));
        this.map.put(MediaType.class, this._createHeaderDelegate(MediaType.class));
        this.map.put(CacheControl.class, this._createHeaderDelegate(CacheControl.class));
        this.map.put(NewCookie.class, this._createHeaderDelegate(NewCookie.class));
        this.map.put(Cookie.class, this._createHeaderDelegate(Cookie.class));
        this.map.put(URI.class, this._createHeaderDelegate(URI.class));
        this.map.put(Date.class, this._createHeaderDelegate(Date.class));
        this.map.put(String.class, this._createHeaderDelegate(String.class));
    }

    @Override
    public Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilder();
    }

    @Override
    public Response.ResponseBuilder createResponseBuilder() {
        return new OutboundJaxrsResponse.Builder(new OutboundMessageContext());
    }

    @Override
    public UriBuilder createUriBuilder() {
        return new JerseyUriBuilder();
    }

    @Override
    public Link.Builder createLinkBuilder() {
        return new JerseyLink.Builder();
    }

    @Override
    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("type parameter cannot be null");
        }
        RuntimeDelegate.HeaderDelegate<?> delegate = this.map.get(type);
        if (delegate != null) {
            return delegate;
        }
        return this._createHeaderDelegate(type);
    }

    private <T> RuntimeDelegate.HeaderDelegate<T> _createHeaderDelegate(Class<T> type) {
        for (HeaderDelegateProvider hp : this.hps) {
            if (!hp.supports(type)) continue;
            return hp;
        }
        return null;
    }
}

