/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class SlackRequest {
    private String operation;
    private Map<String, String> arguments = new HashMap<String, String>();
    private String token;

    public SlackRequest(String token) {
        this.token = token;
    }

    public String getOperation() {
        return this.operation;
    }

    public SlackRequest setOperation(String operation) {
        this.operation = operation;
        return this;
    }

    public SlackRequest addArgument(String argName, String argValue) {
        if (argValue == null) {
            return this;
        }
        try {
            this.arguments.put(argName, URLEncoder.encode(argValue, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public SlackRequest enablePretty() {
        this.arguments.put("pretty", "1");
        return this;
    }

    public String createUrl() {
        String url = "https://slack.com/api/" + this.operation + "?token=" + this.token;
        for (Map.Entry<String, String> entry : this.arguments.entrySet()) {
            url = url.concat("&" + entry.getKey() + "=" + entry.getValue());
        }
        return url;
    }
}

