/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.connectivity;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.pool.KeyedObjectPool;
import org.mule.api.MetadataAware;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.devkit.capability.Capabilities;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.config.PoolingProfile;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectionAdapter;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectionManager;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectorAdapter;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementConnectorFactory;
import org.mule.devkit.3.6.1.shade.connection.management.ConnectionManagementProcessTemplate;
import org.mule.devkit.3.6.1.shade.connection.management.UnableToAcquireConnectionException;
import org.mule.devkit.3.6.1.shade.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.processor.ExpressionEvaluatorSupport;
import org.mule.modules.slack.adapters.SlackConnectorConnectionManagementAdapter;
import org.mule.modules.slack.connectivity.ConnectionManagementConfigTypeSlackConnectorConnectionKey;
import org.mule.modules.slack.connectivity.ConnectionManagementStrategySlackConnectorAdapter;
import org.mule.modules.slack.metadata.AllChannelCategory;
import org.mule.modules.slack.metadata.ChannelCategory;
import org.mule.modules.slack.metadata.GroupCategory;
import org.mule.modules.slack.metadata.UserCategory;
import org.mule.modules.slack.pooling.DevkitGenericKeyedObjectPool;
import org.mule.modules.slack.strategy.ConnectionManagementStrategy;

public class SlackConnectorConfigTypeConnectionManagementConnectionManager
extends ExpressionEvaluatorSupport
implements MetadataAware,
MuleContextAware,
ProcessAdapter<SlackConnectorConnectionManagementAdapter>,
Capabilities,
Disposable,
Initialisable,
Testable,
ConnectorMetaDataEnabled,
ConnectionManagementConnectionManager<ConnectionManagementConfigTypeSlackConnectorConnectionKey, SlackConnectorConnectionManagementAdapter, ConnectionManagementStrategy> {
    private String accessToken;
    protected MuleContext muleContext;
    private KeyedObjectPool connectionPool;
    protected PoolingProfile poolingProfile;
    protected RetryPolicyTemplate retryPolicyTemplate;
    private static final String MODULE_NAME = "Slack";
    private static final String MODULE_VERSION = "1.0.0";
    private static final String DEVKIT_VERSION = "3.6.1";
    private static final String DEVKIT_BUILD = "UNNAMED.2405.44720b7";
    private static final String MIN_MULE_VERSION = "3.5.0";

    public void setAccessToken(String value) {
        this.accessToken = value;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setMuleContext(MuleContext value) {
        this.muleContext = value;
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setPoolingProfile(PoolingProfile value) {
        this.poolingProfile = value;
    }

    public PoolingProfile getPoolingProfile() {
        return this.poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate value) {
        this.retryPolicyTemplate = value;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.retryPolicyTemplate;
    }

    public void initialise() {
        this.connectionPool = new DevkitGenericKeyedObjectPool(new ConnectionManagementConnectorFactory(this), this.poolingProfile);
        if (this.retryPolicyTemplate == null) {
            this.retryPolicyTemplate = (RetryPolicyTemplate)this.muleContext.getRegistry().lookupObject("_defaultRetryPolicyTemplate");
        }
    }

    public void dispose() {
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SlackConnectorConnectionManagementAdapter acquireConnection(ConnectionManagementConfigTypeSlackConnectorConnectionKey key) throws Exception {
        return (SlackConnectorConnectionManagementAdapter)this.connectionPool.borrowObject((Object)key);
    }

    @Override
    public void releaseConnection(ConnectionManagementConfigTypeSlackConnectorConnectionKey key, SlackConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.returnObject((Object)key, (Object)connection);
    }

    @Override
    public void destroyConnection(ConnectionManagementConfigTypeSlackConnectorConnectionKey key, SlackConnectorConnectionManagementAdapter connection) throws Exception {
        this.connectionPool.invalidateObject((Object)key, (Object)connection);
    }

    public boolean isCapableOf(ModuleCapability capability) {
        if (capability == ModuleCapability.LIFECYCLE_CAPABLE) {
            return true;
        }
        return capability == ModuleCapability.CONNECTION_MANAGEMENT_CAPABLE;
    }

    public <P> ProcessTemplate<P, SlackConnectorConnectionManagementAdapter> getProcessTemplate() {
        return new ConnectionManagementProcessTemplate(this, this.muleContext);
    }

    @Override
    public ConnectionManagementConfigTypeSlackConnectorConnectionKey getDefaultConnectionKey() {
        return new ConnectionManagementConfigTypeSlackConnectorConnectionKey(this.getAccessToken());
    }

    @Override
    public ConnectionManagementConfigTypeSlackConnectorConnectionKey getEvaluatedConnectionKey(MuleEvent event) throws Exception {
        if (event != null) {
            String _transformedAccessToken = (String)this.evaluateAndTransform(this.muleContext, event, this.getClass().getDeclaredField("accessToken").getGenericType(), null, this.getAccessToken());
            if (_transformedAccessToken == null) {
                throw new UnableToAcquireConnectionException("Parameter accessToken in method connect can't be null because is not @Optional");
            }
            return new ConnectionManagementConfigTypeSlackConnectorConnectionKey(_transformedAccessToken);
        }
        return this.getDefaultConnectionKey();
    }

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getModuleVersion() {
        return MODULE_VERSION;
    }

    public String getDevkitVersion() {
        return DEVKIT_VERSION;
    }

    public String getDevkitBuild() {
        return DEVKIT_BUILD;
    }

    public String getMinMuleVersion() {
        return MIN_MULE_VERSION;
    }

    @Override
    public ConnectionManagementConfigTypeSlackConnectorConnectionKey getConnectionKey(MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        return this.getEvaluatedConnectionKey(event);
    }

    @Override
    public ConnectionManagementConnectionAdapter newConnection() {
        ConnectionManagementStrategySlackConnectorAdapter connection = new ConnectionManagementStrategySlackConnectorAdapter();
        return connection;
    }

    @Override
    public ConnectionManagementConnectorAdapter newConnector(ConnectionManagementConnectionAdapter<ConnectionManagementStrategy, ConnectionManagementConfigTypeSlackConnectorConnectionKey> connection) {
        SlackConnectorConnectionManagementAdapter connector = new SlackConnectorConnectionManagementAdapter();
        connector.setConnectionStrategy(connection.getStrategy());
        return connector;
    }

    @Override
    public ConnectionManagementConnectionAdapter getConnectionAdapter(ConnectionManagementConnectorAdapter adapter) {
        SlackConnectorConnectionManagementAdapter connector = (SlackConnectorConnectionManagementAdapter)adapter;
        ConnectionManagementConnectionAdapter strategy = (ConnectionManagementConnectionAdapter)((Object)connector.getConnectionStrategy());
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResult test() {
        DefaultTestResult result;
        SlackConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigTypeSlackConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            result = new DefaultTestResult(Result.Status.SUCCESS);
        }
        catch (Exception e) {
            try {
                this.destroyConnection(key, connection);
            }
            catch (Exception ie) {
                // empty catch block
            }
            result = (DefaultTestResult)ConnectivityTestingErrorHandler.buildFailureTestResult(e);
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Result<List<MetaDataKey>> getMetaDataKeys() {
        SlackConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigTypeSlackConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            try {
                ArrayList<MetaDataKey> gatheredMetaDataKeys = new ArrayList<MetaDataKey>();
                ChannelCategory channelCategory = new ChannelCategory();
                channelCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(this.fillCategory(channelCategory.getEntities(), "ChannelCategory"));
                UserCategory userCategory = new UserCategory();
                userCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(this.fillCategory(userCategory.getEntities(), "UserCategory"));
                GroupCategory groupCategory = new GroupCategory();
                groupCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(this.fillCategory(groupCategory.getEntities(), "GroupCategory"));
                AllChannelCategory allChannelCategory = new AllChannelCategory();
                allChannelCategory.setMyconnector(connection);
                gatheredMetaDataKeys.addAll(this.fillCategory(allChannelCategory.getEntities(), "AllChannelCategory"));
                DefaultResult defaultResult = new DefaultResult(gatheredMetaDataKeys, Result.Status.SUCCESS);
                return defaultResult;
            }
            catch (Exception e) {
                DefaultResult channelCategory;
                block19: {
                    channelCategory = new DefaultResult(null, Result.Status.FAILURE, "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", (FailureType)MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, (Throwable)e);
                    if (connection == null) break block19;
                    try {
                        this.releaseConnection(key, connection);
                    }
                    catch (Exception ie) {
                        // empty catch block
                    }
                }
                return channelCategory;
                catch (Exception e2) {
                    try {
                        this.destroyConnection(key, connection);
                    }
                    catch (Exception ie) {
                        // empty catch block
                    }
                    DefaultResult defaultResult = ConnectivityTestingErrorHandler.buildFailureTestResult(e2);
                    return defaultResult;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
    }

    private List<MetaDataKey> fillCategory(List<MetaDataKey> metadataKeys, String categoryClassName) {
        for (MetaDataKey metaDataKey : metadataKeys) {
            ((DefaultMetaDataKey)metaDataKey).setCategory(categoryClassName);
        }
        return metadataKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        SlackConnectorConnectionManagementAdapter connection = null;
        ConnectionManagementConfigTypeSlackConnectorConnectionKey key = this.getDefaultConnectionKey();
        try {
            connection = this.acquireConnection(key);
            try {
                MetaData metaData = null;
                TypeDescribingProperty property = (TypeDescribingProperty)metaDataKey.getProperty(TypeDescribingProperty.class);
                String category = ((DefaultMetaDataKey)metaDataKey).getCategory();
                if (category == null) throw new Exception("Invalid key type. There is no matching category for [" + metaDataKey.getId() + "]. All keys must contain a category with any of the following options:[ChannelCategory, UserCategory, GroupCategory, AllChannelCategory]");
                if (category.equals("ChannelCategory")) {
                    ChannelCategory channelCategory = new ChannelCategory();
                    channelCategory.setMyconnector(connection);
                    metaData = channelCategory.describeEntity(metaDataKey);
                } else if (category.equals("UserCategory")) {
                    UserCategory userCategory = new UserCategory();
                    userCategory.setMyconnector(connection);
                    metaData = userCategory.describeEntity(metaDataKey);
                } else if (category.equals("GroupCategory")) {
                    GroupCategory groupCategory = new GroupCategory();
                    groupCategory.setMyconnector(connection);
                    metaData = groupCategory.describeEntity(metaDataKey);
                } else {
                    if (!category.equals("AllChannelCategory")) throw new Exception("Invalid key type. There is no matching category for [" + metaDataKey.getId() + "]. All keys must contain a category with any of the following options:[ChannelCategory, UserCategory, GroupCategory, AllChannelCategory]" + ", but found [" + category + "] instead");
                    AllChannelCategory allChannelCategory = new AllChannelCategory();
                    allChannelCategory.setMyconnector(connection);
                    metaData = allChannelCategory.describeEntity(metaDataKey);
                }
                metaData.getPayload().addProperty((MetaDataModelProperty)new StructureIdentifierMetaDataModelProperty(metaDataKey, false));
                DefaultResult defaultResult = new DefaultResult((Object)metaData);
                return defaultResult;
            }
            catch (Exception e) {
                DefaultResult property = new DefaultResult(null, Result.Status.FAILURE, this.getMetaDataException(metaDataKey), (FailureType)MetaDataFailureType.ERROR_METADATA_RETRIEVER, (Throwable)e);
                if (connection == null) return property;
                try {
                    this.releaseConnection(key, connection);
                    return property;
                }
                catch (Exception ie) {
                    // empty catch block
                }
                return property;
                catch (Exception e2) {
                    try {
                        this.destroyConnection(key, connection);
                    }
                    catch (Exception ie) {
                        // empty catch block
                    }
                    DefaultResult defaultResult = ConnectivityTestingErrorHandler.buildFailureTestResult(e2);
                    return defaultResult;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    this.releaseConnection(key, connection);
                }
                catch (Exception ie) {}
            }
        }
    }

    private String getMetaDataException(MetaDataKey key) {
        if (key != null && key.getId() != null) {
            return "There was an error retrieving metadata from key: " + key.getId() + " after acquiring the connection, for more detailed information please read the provided stacktrace";
        }
        return "There was an error retrieving metadata after acquiring the connection, MetaDataKey is null or its id is null, for more detailed information please read the provided stacktrace";
    }
}

