/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.oauth;

import java.io.Serializable;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.store.ObjectStore;
import org.mule.modules.slack.adapters.SlackConnectorOAuth2Adapter;
import org.mule.modules.slack.oauth.SlackConnectorOAuthClientFactory;
import org.mule.modules.slack.strategy.OAuth2ConnectionStrategy;
import org.mule.security.oauth.BaseOAuth2Manager;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.slf4j.shaded.Logger;
import org.slf4j.shaded.LoggerFactory;

public class SlackConnectorOAuthManager
extends BaseOAuth2Manager<OAuth2Adapter> {
    private static Logger logger = LoggerFactory.getLogger(SlackConnectorOAuthManager.class);

    protected Logger getLogger() {
        return logger;
    }

    public void setConsumerKey(String value) {
        super.setConsumerKey(value);
    }

    public void setConsumerSecret(String value) {
        super.setConsumerSecret(value);
    }

    protected OAuth2Adapter instantiateAdapter() {
        return new SlackConnectorOAuth2Adapter((OAuth2Manager<OAuth2Adapter>)this);
    }

    protected KeyedPoolableObjectFactory createPoolFactory(OAuth2Manager<OAuth2Adapter> oauthManager, ObjectStore<Serializable> objectStore) {
        return new SlackConnectorOAuthClientFactory(oauthManager, objectStore);
    }

    protected void setCustomProperties(OAuth2Adapter adapter) {
        SlackConnectorOAuth2Adapter connector = (SlackConnectorOAuth2Adapter)adapter;
        ((OAuth2ConnectionStrategy)connector.getConnectionStrategy()).setConsumerKey(this.getConsumerKey());
        ((OAuth2ConnectionStrategy)connector.getConnectionStrategy()).setConsumerSecret(this.getConsumerSecret());
    }

    protected void fetchCallbackParameters(OAuth2Adapter adapter, String response) {
        SlackConnectorOAuth2Adapter connector = (SlackConnectorOAuth2Adapter)adapter;
        ExpressionManager expressionManager = this.muleContext.getExpressionManager();
        DefaultMuleMessage muleMessage = new DefaultMuleMessage((Object)response, this.muleContext);
    }

    public void setOnNoToken(OnNoTokenPolicy policy) {
        this.getDefaultUnauthorizedConnector().setOnNoTokenPolicy(policy);
    }
}

