/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.strategy;

import org.mule.api.ConnectionException;
import org.mule.api.ConnectionExceptionCode;
import org.mule.modules.slack.client.SlackClient;
import org.mule.modules.slack.strategy.SlackConnectionStrategy;

public class ConnectionManagementStrategy
implements SlackConnectionStrategy {
    SlackClient slack;
    String accessToken;

    public void connect(String accessToken) throws ConnectionException {
        this.slack = new SlackClient(accessToken);
        if (!this.slack.isConnected().booleanValue()) {
            throw new ConnectionException(ConnectionExceptionCode.INCORRECT_CREDENTIALS, "Invalid Token", "Invalid Token");
        }
        this.accessToken = accessToken;
    }

    public void disconnect() {
    }

    public boolean isConnected() {
        return this.slack != null;
    }

    public String connectionId() {
        return "001";
    }

    @Override
    public SlackClient getSlackClient() {
        return this.slack;
    }

    @Override
    public Boolean isAuthorized() {
        if (this.accessToken == null) {
            return false;
        }
        return true;
    }
}

