/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.websocket.DeploymentException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.callback.SourceCallback;
import org.mule.modules.slack.client.SlackClient;
import org.mule.modules.slack.client.exceptions.SlackException;
import org.mule.modules.slack.client.exceptions.UserNotFoundException;
import org.mule.modules.slack.client.model.User;
import org.mule.modules.slack.client.model.channel.Channel;
import org.mule.modules.slack.client.model.chat.Message;
import org.mule.modules.slack.client.model.chat.MessageResponse;
import org.mule.modules.slack.client.model.chat.attachment.ChatAttachment;
import org.mule.modules.slack.client.model.file.FileUploadResponse;
import org.mule.modules.slack.client.model.group.Group;
import org.mule.modules.slack.client.model.im.DirectMessageChannel;
import org.mule.modules.slack.client.model.im.DirectMessageChannelCreationResponse;
import org.mule.modules.slack.client.rtm.ConfigurableHandler;
import org.mule.modules.slack.client.rtm.filter.EventFilter;
import org.mule.modules.slack.client.rtm.filter.EventNotifier;
import org.mule.modules.slack.client.rtm.filter.MessagesNotifier;
import org.mule.modules.slack.client.rtm.filter.OnlyTypeNotifier;
import org.mule.modules.slack.client.rtm.filter.SelfEventsFilter;
import org.mule.modules.slack.config.BasicSlackConfig;
import org.mule.modules.slack.config.SlackOAuth2Config;
import org.mule.modules.slack.retrievers.ChannelMessageRetriever;
import org.mule.modules.slack.retrievers.DirectMessageRetriever;
import org.mule.modules.slack.retrievers.GroupMessageRetriever;
import org.mule.modules.slack.retrievers.MessageRetriever;

public class SlackConnector {
    private static final Logger logger = Logger.getLogger(SlackConnector.class);
    private static final String NUMBER_OF_MESSAGES = "Number of messages to return, the value should be between 1 and 1000.";
    public static final String USER_TYPING_EVENT = "user_typing";
    private static final String IM_CREATED = "im_created";
    private static final String FILE_CREATED = "file_created";
    private static final String FILE_SHARED = "file_shared";
    private static final String FILE_PUBLIC = "file_public";
    @Inject
    MuleContext muleContext;
    BasicSlackConfig slackConfig;

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public User getUserInfo(String id) {
        return this.slack().getUserInfo(id);
    }

    public User getUserInfoByName(String username) throws UserNotFoundException {
        return this.slack().getUserInfoByName(username);
    }

    public List<User> getUserList() {
        return this.slack().getUserList();
    }

    public List<Channel> getChannelList() {
        return this.slack().getChannelList();
    }

    public List<Message> getChannelHistory(String channelId, String latestTimestamp, String oldestTimestamp, String mountOfMessages) {
        return this.slack().getChannelHistory(channelId, latestTimestamp, oldestTimestamp, mountOfMessages);
    }

    public Channel getChannelInfo(String channelId) {
        return this.slack().getChannelById(channelId);
    }

    public Channel getChannelByName(String channelName) {
        return this.slack().getChannelByName(channelName);
    }

    public Channel createChannel(String channelName) {
        return this.slack().createChannel(channelName);
    }

    public Channel renameChannel(String channelId, String channelName) {
        return this.slack().renameChannel(channelId, channelName);
    }

    public Channel joinChannel(String channelName) {
        return this.slack().joinChannel(channelName);
    }

    public Boolean leaveChannel(String channelId) {
        return this.slack().leaveChannel(channelId);
    }

    public Boolean archiveChannel(String channelID) {
        return this.slack().archiveChannel(channelID);
    }

    public Boolean unarchiveChannel(String channelID) {
        return this.slack().unarchiveChannel(channelID);
    }

    public Boolean setChannelTopic(String channelID, String topic) {
        return this.slack().setChannelTopic(channelID, topic);
    }

    public Boolean setChannelPurpose(String channelID, String purpose) {
        return this.slack().setChannelPurpose(channelID, purpose);
    }

    public MessageResponse postMessage(String message, String channelId, String username, String iconURL, Boolean asUser) {
        return this.slack().sendMessage(message, channelId, username, iconURL, BooleanUtils.toBoolean((Boolean)asUser));
    }

    public MessageResponse postMessageWithAttachment(String message, String channelId, String username, String iconURL, List<ChatAttachment> chatAttachmentList, Boolean asUser) {
        return this.slack().sendMessageWithAttachment(message, channelId, username, iconURL, chatAttachmentList, BooleanUtils.toBoolean((Boolean)asUser));
    }

    public Boolean deleteMessage(String timeStamp, String channelId) {
        return this.slack().deleteMessage(timeStamp, channelId);
    }

    public Boolean updateMessage(String timeStamp, String channelId, String message) {
        return this.slack().updateMessage(timeStamp, channelId, message);
    }

    public DirectMessageChannelCreationResponse openDirectMessageChannel(String userId) {
        return this.slack().openDirectMessageChannel(userId);
    }

    public Boolean closeDirectMessageChannel(String channelId) {
        return this.slack().closeDirectMessageChannel(channelId);
    }

    public List<DirectMessageChannel> listDirectMessageChannels() {
        return this.slack().getDirectMessageChannelsList();
    }

    public List<Message> getDMHistory(String channelID, String latestTimestamp, String oldestTimestamp, String mountOfMessages) {
        return this.slack().getDirectChannelHistory(channelID, latestTimestamp, oldestTimestamp, mountOfMessages);
    }

    public List<Group> getGroupList() {
        return this.slack().getGroupList();
    }

    public List<Message> getGroupHistory(String groupID, String latestTimestamp, String oldestTimestamp, String mountOfMessages) {
        return this.slack().getGroupHistory(groupID, latestTimestamp, oldestTimestamp, mountOfMessages);
    }

    public Boolean setGroupTopic(String channelID, String topic) {
        return this.slack().setGroupTopic(channelID, topic);
    }

    public Boolean setGroupPurpose(String channelID, String purpose) {
        return this.slack().setGroupPurpose(channelID, purpose);
    }

    public Group createGroup(String groupName) {
        return this.slack().createGroup(groupName);
    }

    public Boolean closeGroup(String channelID) {
        return this.slack().closeGroup(channelID);
    }

    public Boolean openGroup(String channelID) {
        return this.slack().openGroup(channelID);
    }

    public Boolean archiveGroup(String channelID) {
        return this.slack().archiveGroup(channelID);
    }

    public Boolean unarchiveGroup(String channelID) {
        return this.slack().unarchiveGroup(channelID);
    }

    public Group renameGroup(String groupId, String groupName) {
        return this.slack().renameGroup(groupId, groupName);
    }

    public Group getGroupInfo(String channelId) {
        return this.slack().getGroupInfo(channelId);
    }

    public Boolean leaveGroup(String channelId) {
        return this.slack().leaveGroup(channelId);
    }

    public FileUploadResponse uploadFile(String channelID, String fileName, String fileType, String title, String initialComment, String filePath) throws IOException {
        return this.slack().sendFile(channelID, fileName, fileType, title, initialComment, filePath);
    }

    public FileUploadResponse uploadFileAsInputStreams(String channelID, String fileName, String fileType, String title, String initialComment, InputStream inputStream) throws IOException {
        return this.slack().sendFile(channelID, fileName, fileType, title, initialComment, inputStream);
    }

    public void classForName(String className, MuleEvent muleEvent) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        MuleContext muleContext = muleEvent.getMuleContext();
        System.out.println(className);
        Class<?> aClass = Class.forName(className, true, muleContext.getExecutionClassLoader());
        EventFilter o = (EventFilter)aClass.newInstance();
        System.out.println(o.shouldAccept(new HashMap<String, Object>()));
        System.out.println(o);
        System.out.println(aClass);
    }

    public Message retrieveEvents(SourceCallback sourceCallback, Boolean messages, Boolean userTyping, Boolean directMessages, Boolean onlyNewMessages, Boolean ignoreSelfEvents, Boolean imCreated, Boolean fileCreated, Boolean fileShared, Boolean filePublic, String filterClassName, String notifierClassName) throws IOException, InterruptedException, DeploymentException {
        if (this.getSlackConfig() instanceof SlackOAuth2Config) {
            logger.error((Object)"Retrieve Events source doesn't work with OAuth 2 configuration, please use Token Config");
            logger.error((Object)"Shutting down Retrieving of Messages!");
            return new Message();
        }
        ArrayList<EventNotifier> observerList = new ArrayList<EventNotifier>();
        ArrayList<EventFilter> eventFilterList = new ArrayList<EventFilter>();
        if (messages.booleanValue()) {
            observerList.add(new MessagesNotifier(directMessages, onlyNewMessages));
        }
        if (userTyping.booleanValue()) {
            observerList.add(new OnlyTypeNotifier(USER_TYPING_EVENT));
        }
        if (imCreated.booleanValue()) {
            observerList.add(new OnlyTypeNotifier(IM_CREATED));
        }
        if (fileCreated.booleanValue()) {
            observerList.add(new OnlyTypeNotifier(FILE_CREATED));
        }
        if (fileShared.booleanValue()) {
            observerList.add(new OnlyTypeNotifier(FILE_SHARED));
        }
        if (filePublic.booleanValue()) {
            observerList.add(new OnlyTypeNotifier(FILE_PUBLIC));
        }
        if (StringUtils.isNotEmpty((String)filterClassName)) {
            eventFilterList.add(this.getFilterInstance(filterClassName));
        }
        if (StringUtils.isNotEmpty((String)notifierClassName)) {
            observerList.add(this.getNotifierInstance(notifierClassName));
        }
        if (ignoreSelfEvents.booleanValue()) {
            eventFilterList.add(new SelfEventsFilter(this.slack().getSelfId()));
        }
        this.slack().startRealTimeCommunication(new ConfigurableHandler(sourceCallback, observerList, eventFilterList));
        System.out.println("Ending!");
        return null;
    }

    private EventFilter getFilterInstance(String className) {
        try {
            logger.info((Object)("Detected custom filter class: " + className));
            Class<?> aClass = Class.forName(className, true, this.getMuleContext().getExecutionClassLoader());
            return (EventFilter)aClass.newInstance();
        }
        catch (ClassCastException e) {
            String errorMessage = String.format("The configured class [%s] does not implements 'org.mule.modules.slack.client.rtm.filter.SlackEventFilter'", className);
            logger.error((Object)errorMessage);
            throw new SlackException(errorMessage);
        }
        catch (Exception e) {
            logger.error((Object)"Error loading Custom filter class", (Throwable)e);
            throw new SlackException("Error loading Custom filter class", e);
        }
    }

    private EventNotifier getNotifierInstance(String className) {
        try {
            logger.info((Object)("Detected custom filter class: " + className));
            Class<?> aClass = Class.forName(className, true, this.getMuleContext().getExecutionClassLoader());
            return (EventNotifier)aClass.newInstance();
        }
        catch (ClassCastException e) {
            String errorMessage = String.format("The configured class [%s] does not implements 'org.mule.modules.slack.client.rtm.filter.EventObserver'", className);
            logger.error((Object)errorMessage);
            throw new SlackException(errorMessage);
        }
        catch (Exception e) {
            logger.error((Object)"Error loading Custom filter class", (Throwable)e);
            throw new SlackException("Error loading Custom filter class", e);
        }
    }

    private Boolean falseIfNull(Boolean aBoolean) {
        if (aBoolean == null) {
            return false;
        }
        return aBoolean;
    }

    public Message retrieveMessages(SourceCallback source, Integer messageRetrieverInterval, String channelID) throws Exception {
        if (this.getSlackConfig() instanceof SlackOAuth2Config) {
            logger.error((Object)"Retrieve Messages source doesn't work with OAuth 2 configuration, please use Token Config");
            logger.error((Object)"Shutting down Retrieving of Messages!");
            return new Message();
        }
        logger.warn((Object)"This Retrieve Messages Endpoint is deprecated. Please use 'Retrieve Events' endpoint.");
        while (!this.getSlackConfig().isAuthorized().booleanValue()) {
            Thread.sleep(1000L);
            logger.debug((Object)"Waiting authorization!");
        }
        MessageRetriever messageRetriever = this.getMessageVerifierForChannel(channelID);
        String oldestTimeStamp = messageRetriever.retrieve(this.slack(), channelID, null, null, "1").get(0).getTs();
        block1: while (true) {
            Thread.sleep(messageRetrieverInterval.intValue());
            List<Message> messages = messageRetriever.retrieve(this.slack(), channelID, null, oldestTimeStamp, "1000");
            if (!messages.isEmpty()) {
                oldestTimeStamp = messages.get(0).getTs();
            }
            Integer i = messages.size();
            while (true) {
                if (i <= 0) continue block1;
                source.process((Object)messages.get(i - 1));
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i - 1);
            }
            break;
        }
    }

    private MessageRetriever getMessageVerifierForChannel(String channelID) throws Exception {
        if (channelID.toLowerCase().startsWith("g")) {
            logger.info((Object)("Started retrieving messages of channel: " + this.slack().getGroupInfo(channelID).getName() + "!"));
            return new GroupMessageRetriever();
        }
        if (channelID.toLowerCase().startsWith("c")) {
            logger.info((Object)("Started retrieving messages of channel: " + this.slack().getChannelById(channelID).getName() + "!"));
            return new ChannelMessageRetriever();
        }
        if (channelID.toLowerCase().startsWith("d")) {
            logger.info((Object)"Started retrieving messages of direct message channel!");
            return new DirectMessageRetriever();
        }
        throw new Exception("Incorrect name for channel");
    }

    public SlackClient slack() {
        return this.slackConfig.getSlackClient();
    }

    public BasicSlackConfig getSlackConfig() {
        return this.slackConfig;
    }

    public void setSlackConfig(BasicSlackConfig slackConfig) {
        this.slackConfig = slackConfig;
    }
}

