/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.slack.client.rtm;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.api.callback.SourceCallback;
import org.mule.modules.slack.client.rtm.EventHandler;
import org.mule.modules.slack.client.rtm.filter.EventFilter;
import org.mule.modules.slack.client.rtm.filter.EventNotifier;

public class ConfigurableHandler
implements EventHandler {
    SourceCallback sourceCallback;
    Gson gson;
    Class<? extends Map> stringStringMap = HashMap.class;
    private List<EventNotifier> observerList;
    private List<EventFilter> eventFilterList;

    public ConfigurableHandler(SourceCallback sourceCallback, List<EventNotifier> eventNotifierList, List<EventFilter> eventFilterList) {
        this.sourceCallback = sourceCallback;
        this.gson = new Gson();
        this.observerList = eventNotifierList;
        this.eventFilterList = eventFilterList;
    }

    @Override
    public void onMessage(String message) {
        Map messageMap = (Map)this.gson.fromJson(message, this.stringStringMap);
        if (this.shouldBeAccepted(messageMap, this.eventFilterList) && this.shouldBeSent(messageMap, this.observerList)) {
            try {
                this.sourceCallback.process((Object)message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean shouldBeAccepted(Map<String, Object> message, List<EventFilter> filterList) {
        for (EventFilter eventFilter : filterList) {
            if (eventFilter.shouldAccept(message)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldBeSent(Map<String, Object> message, List<EventNotifier> observerList) {
        for (EventNotifier eventNotifier : observerList) {
            if (!eventNotifier.shouldSend(message)) continue;
            return true;
        }
        return false;
    }
}

