
package org.mule.modules.slack.generated.adapters;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.mule.common.DefaultResult;
import org.mule.common.DefaultTestResult;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.Testable;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataFailureType;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.key.property.TypeDescribingProperty;
import org.mule.common.metadata.property.StructureIdentifierMetaDataModelProperty;
import org.mule.devkit.internal.connectivity.ConnectivityTestingErrorHandler;
import org.mule.devkit.internal.metadata.MetaDataGeneratorUtils;
import org.mule.modules.slack.SlackConnector;
import org.mule.modules.slack.config.SlackTokenConfig;
import org.mule.modules.slack.metadata.AllChannelCategory;
import org.mule.modules.slack.metadata.ChannelCategory;
import org.mule.modules.slack.metadata.GroupCategory;
import org.mule.modules.slack.metadata.UserCategory;


/**
 * A <code>SlackConnectorSlackTokenConfigBasicAdapter</code> is a wrapper around {@link SlackConnector } that represents the strategy {@link SlackTokenConfig }
 * 
 */
@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.8.0", date = "2015-12-18T04:48:25-03:00", comments = "Build UNNAMED.2762.e3b1307")
public class SlackConnectorSlackTokenConfigBasicAdapter
    extends SlackConnectorProcessAdapter
    implements Testable, ConnectorMetaDataEnabled
{


    @Override
    public TestResult test() {
        DefaultTestResult result;
        try {
            ((SlackTokenConfig) getSlackConfig()).connect();
            result = new DefaultTestResult(Result.Status.SUCCESS);
        } catch (Exception e) {
            result = ((DefaultTestResult) ConnectivityTestingErrorHandler.buildFailureTestResult(e));
        }
        return result;
    }

    @Override
    public Result<List<MetaDataKey>> getMetaDataKeys() {
        try {
            List<MetaDataKey> gatheredMetaDataKeys = new ArrayList<MetaDataKey>();
            GroupCategory groupCategory = new GroupCategory();
            groupCategory.setMyconnector(this);
            gatheredMetaDataKeys.addAll(MetaDataGeneratorUtils.fillCategory(groupCategory.getEntities(), "GroupCategory"));
            AllChannelCategory allChannelCategory = new AllChannelCategory();
            allChannelCategory.setMyconnector(this);
            gatheredMetaDataKeys.addAll(MetaDataGeneratorUtils.fillCategory(allChannelCategory.getEntities(), "AllChannelCategory"));
            ChannelCategory channelCategory = new ChannelCategory();
            channelCategory.setMyconnector(this);
            gatheredMetaDataKeys.addAll(MetaDataGeneratorUtils.fillCategory(channelCategory.getEntities(), "ChannelCategory"));
            UserCategory userCategory = new UserCategory();
            userCategory.setMyconnector(this);
            gatheredMetaDataKeys.addAll(MetaDataGeneratorUtils.fillCategory(userCategory.getEntities(), "UserCategory"));
            return new DefaultResult<List<MetaDataKey>>(gatheredMetaDataKeys, (Result.Status.SUCCESS));
        } catch (Exception e) {
            return new DefaultResult<List<MetaDataKey>>(null, (Result.Status.FAILURE), "There was an error retrieving the metadata keys from service provider after acquiring connection, for more detailed information please read the provided stacktrace", MetaDataFailureType.ERROR_METADATA_KEYS_RETRIEVER, e);
        }
    }

    @Override
    public Result<MetaData> getMetaData(MetaDataKey metaDataKey) {
        try {
            MetaData metaData = null;
            TypeDescribingProperty property = metaDataKey.getProperty(TypeDescribingProperty.class);
            String category = ((DefaultMetaDataKey) metaDataKey).getCategory();
            if (category!= null) {
                if (category.equals("GroupCategory")) {
                    GroupCategory groupCategory = new GroupCategory();
                    groupCategory.setMyconnector(this);
                    metaData = groupCategory.describeEntity(metaDataKey);
                } else {
                    if (category.equals("AllChannelCategory")) {
                        AllChannelCategory allChannelCategory = new AllChannelCategory();
                        allChannelCategory.setMyconnector(this);
                        metaData = allChannelCategory.describeEntity(metaDataKey);
                    } else {
                        if (category.equals("ChannelCategory")) {
                            ChannelCategory channelCategory = new ChannelCategory();
                            channelCategory.setMyconnector(this);
                            metaData = channelCategory.describeEntity(metaDataKey);
                        } else {
                            if (category.equals("UserCategory")) {
                                UserCategory userCategory = new UserCategory();
                                userCategory.setMyconnector(this);
                                metaData = userCategory.describeEntity(metaDataKey);
                            } else {
                                throw new Exception(((("Invalid key type. There is no matching category for ["+ metaDataKey.getId())+"]. All keys must contain a category with any of the following options:[GroupCategory, AllChannelCategory, ChannelCategory, UserCategory]")+((", but found ["+ category)+"] instead")));
                            }
                        }
                    }
                }
            } else {
                throw new Exception((("Invalid key type. There is no matching category for ["+ metaDataKey.getId())+"]. All keys must contain a category with any of the following options:[GroupCategory, AllChannelCategory, ChannelCategory, UserCategory]"));
            }
            metaData.getPayload().addProperty(new StructureIdentifierMetaDataModelProperty(metaDataKey, false));
            return new DefaultResult<MetaData>(metaData);
        } catch (Exception e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), MetaDataGeneratorUtils.getMetaDataException(metaDataKey), MetaDataFailureType.ERROR_METADATA_RETRIEVER, e);
        }
    }

}
