/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.shaded.message.internal;

import java.text.ParseException;
import java.util.Locale;
import javax.inject.Singleton;
import org.glassfish.jersey.shaded.internal.LocalizationMessages;
import org.glassfish.jersey.shaded.message.internal.LanguageTag;
import org.glassfish.jersey.shaded.message.internal.Utils;
import org.glassfish.jersey.shaded.spi.HeaderDelegateProvider;

@Singleton
public class LocaleProvider
implements HeaderDelegateProvider<Locale> {
    @Override
    public boolean supports(Class<?> type) {
        return Locale.class.isAssignableFrom(type);
    }

    @Override
    public String toString(Locale header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.LOCALE_IS_NULL());
        if (header.getCountry().length() == 0) {
            return header.getLanguage();
        }
        StringBuilder sb = new StringBuilder(header.getLanguage());
        return sb.append('-').append(header.getCountry()).toString();
    }

    @Override
    public Locale fromString(String header) {
        Utils.throwIllegalArgumentExceptionIfNull(header, LocalizationMessages.LOCALE_IS_NULL());
        try {
            LanguageTag lt = new LanguageTag(header);
            return lt.getAsLocale();
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Error parsing date '" + header + "'", ex);
        }
    }
}

